% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pressuRe_functions.R
\name{create_mask}
\alias{create_mask}
\title{Create mask}
\usage{
create_mask(
  pressure_data,
  n_verts = 4,
  n_masks = 1,
  threshold = 0.005,
  plot_existing_mask = TRUE,
  image = "max",
  mask_names = c("default"),
  preview = TRUE
)
}
\arguments{
\item{pressure_data}{List. First item is a 3D array covering each timepoint
of the measurement.}

\item{n_verts}{Numeric. Number of vertices in mask}

\item{n_masks}{Numeric. Number of masks to add}

\item{threshold}{Numeric. Distance between adjacent mask vertices before
sharing vertex coordinates}

\item{plot_existing_mask}{Logical. Show existing masks}

\item{image}{String."max" = footprint of maximum sensors. "mean"
average value of sensors over time}

\item{mask_names}{List. Mask names. Default is "custom_mask#"}

\item{preview}{Logical. Show new maks on pressure image}
}
\value{
List. Mask(s) are added to pressure data variable
\itemize{
  \item pressure_array. 3D array covering each timepoint of the measurement.
           z dimension represents time
  \item pressure_system. String defining pressure system
  \item sens_size. Numeric vector with the dimensions of the sensors
  \item time. Numeric value for time between measurements
  \item masks. List
  \item events. List
 }
}
\description{
Allows user to manually define mask region
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
emed_data <- system.file("extdata", "emed_test.lst", package = "pressuRe")
pressure_data <- load_emed(emed_data)
pressure_data <- create_mask(pressure_data, n_verts = 4, n_masks = 1,
threshold = 0.005, plot_existing_mask = TRUE,
image = "max", mask_names = c("default"), preview = TRUE)
\dontshow{\}) # examplesIf}
}
