% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esc_2024_conference_ptp.R
\name{calculate_esc_2024_num_of_rf}
\alias{calculate_esc_2024_num_of_rf}
\title{Calculate Number Of Risk Factors (ESC 2024)}
\usage{
calculate_esc_2024_num_of_rf(
  have_family_history,
  have_smoking_history,
  have_dyslipidemia,
  have_hypertension,
  have_diabetes,
  max_na = 0
)
}
\arguments{
\item{have_family_history}{Input characters (no, yes) to indicate if the patient
has a family history of CAD.
\itemize{
  \item no stands for not having a family history of CAD.
  \item yes stands for having a family history of CAD.
}}

\item{have_smoking_history}{Input characters (no, yes) to indicate if the patient
has a smoking history (current or past smoker).
\itemize{
  \item no stands for not having a smoking history (non-smoker).
  \item yes stands for having a smoking history (current or past smoker).
}}

\item{have_dyslipidemia}{Input characters (no, yes) to indicate if the patient
has dyslipidemia.
\itemize{
  \item no stands for not having dyslipidemia.
  \item yes stands for having dyslipidemia.
}}

\item{have_hypertension}{Input characters (no, yes) to indicate if the patient
has hypertension.
\itemize{
  \item no stands for not having hypertension.
  \item yes stands for having hypertension.
}}

\item{have_diabetes}{Input characters (no, yes) to indicate if the patient
has diabetes.
\itemize{
  \item no stands for not having diabetes.
  \item yes stands for having diabetes.
}}

\item{max_na}{Input integer 0 to 5 to indicate the maximum number of
missing risk factors to tolerate before outputting an \code{NA}.
Default: 0}
}
\value{
An integer indicating the number of risk factors the patient has.
It can also be \code{NA} if the number of missing risk factors exceeds the \code{max_na}
input value.
}
\description{
A function used to calculate the number of
risk factors the patient has. This is used to calculate the pretest
probability of coronary artery disease (CAD) based on the
ESC 2024 guidelines.
}
\examples{
calculate_esc_2024_num_of_rf(
  have_family_history = "yes",
  have_smoking_history = "yes",
  have_dyslipidemia = "yes",
  have_hypertension = "yes",
  have_diabetes = "no"
)

calculate_esc_2024_num_of_rf(
  have_family_history = "no",
  have_smoking_history = "no",
  have_dyslipidemia = "no",
  have_hypertension = NA,
  have_diabetes = "no",
  max_na = 0
)

calculate_esc_2024_num_of_rf(
  have_family_history = "no",
  have_smoking_history = "no",
  have_dyslipidemia = "no",
  have_hypertension = NA,
  have_diabetes = "no",
  max_na = 1
)
}
