% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scalebar.R
\name{plotscalebar}
\alias{plotscalebar}
\title{Raw Plot Scale Bar}
\usage{
plotscalebar(x, y, ht, params, style = "bar", adj = c(0, 0),
  tick.cex = 0.7, bar.cols = c("black", "white"), lwd = 1,
  linecol = "black")
}
\arguments{
\item{x}{The position (user) to draw the scale bar}

\item{y}{The position (user) to draw the scale bar}

\item{ht}{The height(in user coordinates) to draw the scale bar}

\item{params}{Scalebar parameters as generated by \link{scalebarparams}}

\item{style}{One of \code{bar} or \code{ticks}}

\item{adj}{Where to align the scale bar relative to \code{x} and \code{y}}

\item{tick.cex}{If \code{style=="ticks"}, the height of interior ticks.}

\item{bar.cols}{A vector of color names to be repeated for a \code{bar}
style scalebar.}

\item{lwd}{Passed when drawing lines associated with the scalebar}

\item{linecol}{Passed when drawing lines associated with the scalebar}
}
\description{
Just in case anybody is hoping to draw a custom scalebar, this is the
method used to plot it. If you don't know what this is, you should probably
be using \link{addscalebar}.
}
\seealso{
\link{addscalebar}
}

