## to do: gelman.plot does not par mfrow

setMethod("densplot", "prev",
  function(x, exclude_fixed = TRUE, ...){
    ## check inputs
    checkInput(exclude_fixed, "exclude_fixed", class = "logical")

    ## guess which function generated 'x'
    multi <- length(x@par$prior) > 2

    ## calculate number of plots
    if (multi){
      if (exclude_fixed){
        is_fixed <- sapply(x@mcmc, function(x) var(unlist(x)) == 0)
        is_fixed <- head(is_fixed, -1)
        n <- length(x@mcmc) - sum(is_fixed) - 1
        N <- which(!is_fixed)
      } else {
        n <- length(x@mcmc) - 1
        N <- seq(n)
      }
    }

    ## define 'ask'
    ask_old <- par("ask")
    ask_new <- ifelse(multi && prod(par("mfrow")) < n, TRUE, FALSE)
    devAskNewPage(ask_new)
    on.exit(devAskNewPage(ask_old))

    ## density plots
    if (multi){
      for (i in N)
        densplot(x@mcmc[[i]],
                 main = paste("Density of", names(x@mcmc)[i]),
                 ask = FALSE, ...)
    } else {
      densplot(x@mcmc, ask = FALSE, ...)
    }
  }
)

setMethod("traceplot", "prev",
  function(x, exclude_fixed = TRUE, ...){
    ## check inputs
    checkInput(exclude_fixed, "exclude_fixed", class = "logical")

    ## guess which function generated 'x'
    multi <- length(x@par$prior) > 2

    ## calculate number of plots
    if (multi){
      if (exclude_fixed){
        is_fixed <- sapply(x@mcmc, function(x) var(unlist(x)) == 0)
        is_fixed <- head(is_fixed, -1)
        n <- length(x@mcmc) - sum(is_fixed) - 1
        N <- which(!is_fixed)
      } else {
        n <- length(x@mcmc) - 1
        N <- seq(n)
      }
    }

    ## define 'ask'
    ask_old <- par("ask")
    ask_new <- ifelse(multi && prod(par("mfrow")) < n, TRUE, FALSE)
    devAskNewPage(ask_new)
    on.exit(devAskNewPage(ask_old))

    ## density plots
    if (multi){
      for (i in N)
        traceplot(x@mcmc[[i]],
                  main = paste("Trace of", names(x@mcmc)[i]),
                  ask = FALSE, ...)
    } else {
      traceplot(x@mcmc, ask = FALSE, ...)
    }
  }
)

setMethod("gelman.plot", "prev",
  function(x, ...){
    ## guess which function generated 'x'
    multi <- length(x@par$prior) > 2

    ## calculate number of plots
    if (multi){
      is_fixed <- sapply(x@mcmc, function(x) var(unlist(x)) == 0)
      is_fixed <- head(is_fixed, -1)
      n <- length(x@mcmc) - sum(is_fixed) - 1
      N <- which(!is_fixed)
    }

    ## define 'ask'
    ask_old <- par("ask")
    ask_new <- ifelse(multi && prod(par("mfrow")) < n, TRUE, FALSE)
    devAskNewPage(ask_new)
    on.exit(devAskNewPage(ask_old))

    ## density plots
    if (multi){
      for (i in N)
        gelman.plot(x@mcmc[[i]],
                    main = paste("BGR plot of", names(x@mcmc)[i]),
                    ask = TRUE, auto.layout = FALSE, ...)
    } else {
      gelman.plot(x@mcmc, ask = FALSE, ...)
    }
  }
)

setMethod("autocorr.plot", "prev",
  function(x, exclude_fixed = TRUE, chain = 1, ...){
    ## check inputs
    checkInput(exclude_fixed, "exclude_fixed", class = "logical")
    checkInput(chain, "chain", class = "integer", min = 1)

    ## guess which function generated 'x'
    multi <- length(x@par$prior) > 2

    ## calculate number of plots
    if (multi){
      if (chain > length(x@mcmc$TP))
        stop(paste("'x' only has", length(x@mcmc$TP), "chains"))
      if (exclude_fixed){
        is_fixed <- sapply(x@mcmc, function(x) var(unlist(x)) == 0)
        is_fixed <- head(is_fixed, -1)
        n <- length(x@mcmc) - sum(is_fixed) - 1
        N <- which(!is_fixed)
      } else {
        n <- length(x@mcmc) - 1
        N <- seq(n)
      }
    } else {
      if (chain > length(x@mcmc))
        stop(paste("'x' only has", length(x@mcmc), "chains"))
    }

    ## define 'ask'
    ask_old <- par("ask")
    ask_new <- ifelse(multi && prod(par("mfrow")) < n, TRUE, FALSE)
    devAskNewPage(ask_new)
    on.exit(devAskNewPage(ask_old))

    ## density plots
    if (multi){
      for (i in N)
        autocorr.plot(x@mcmc[[i]][[chain]],
                      main = paste("Autocorrelation of", names(x@mcmc)[i]),
                      ask = TRUE, auto.layout = FALSE, ...)
    } else {
      autocorr.plot(x@mcmc[[chain]], ...)
    }
  }
)