% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/currencies.R
\name{historical_exchange_rates}
\alias{historical_exchange_rates}
\title{Retrieve historical exchange rates}
\usage{
historical_exchange_rates(from, to, start_date, end_date)
}
\arguments{
\item{from}{A currency code (see currencies() for supported codes)}

\item{to}{A currency code}

\item{start_date}{A start date (of the form "2010-01-01")}

\item{end_date}{An end date}
}
\value{
A data.frame containing exchange rate data for select currency pair
}
\description{
Retrieves historical exchange rates between a currency pair
}
\examples{
\dontrun{
# Note date range >365 days', and returns 912 rows (as expected)
historical_exchange_rates("USD", to = "AUD", start_date = "2018-01-01", end_date = "2020-06-30")

historical_exchange_rates("USD", to = "AUD",
                          start_date = "2020-01-01", end_date = "2020-06-30")


historical_exchange_rates("AUD", to = "USD",
                          start_date = "2010-01-01", end_date = "2020-06-30")


historical_exchange_rates("AUD", to = "USD",
                          start_date = "2010-01-01", end_date = "2020-06-30")


}


}
