% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcens.R
\name{pcens_cdf.default}
\alias{pcens_cdf.default}
\title{Default method for computing primary event censored CDF}
\usage{
\method{pcens_cdf}{default}(object, q, pwindow, use_numeric = FALSE)
}
\arguments{
\item{object}{A \code{primarycensored} object as created by
\code{\link[=new_pcens]{new_pcens()}}.}

\item{q}{Vector of quantiles}

\item{pwindow}{Primary event window}

\item{use_numeric}{Logical, if TRUE forces use of numeric integration
even for distributions with analytical solutions. This is primarily
useful for testing purposes or for settings where the analytical solution
breaks down.}
}
\value{
Vector of computed primary event censored CDFs
}
\description{
This method serves as a fallback for combinations of delay and primary
event distributions that don't have specific implementations. It uses
the numeric integration method.
}
\details{
This method implements the numerical integration approach for computing
the primary event censored CDF. It uses the same mathematical formulation
as described in the details section of \code{\link[=pprimarycensored]{pprimarycensored()}}, but
applies numerical integration instead of analytical solutions.
}
\seealso{
\code{\link[=pprimarycensored]{pprimarycensored()}} for the mathematical details of the
primary event censored CDF computation.

Low level primary event censored distribution objects and methods
\code{\link{new_pcens}()},
\code{\link{pcens_cdf}()},
\code{\link{pcens_cdf.pcens_pgamma_dunif}()},
\code{\link{pcens_cdf.pcens_plnorm_dunif}()}
}
\concept{pcens}
