% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solution-class.R
\name{solution-class}
\alias{solution-class}
\alias{Solution}
\title{Solution class}
\value{
No return value.
}
\description{
This class is used to represent the solution of the MIP (Mixed-Integer Programming) model.
This includes several methods
to obtain information about both the optimization process and the solution associated with
the planning units and actions. It is created using the \code{\link[=solve]{solve()}}
function.
}
\section{Fields}{

\describe{
\item{$data}{
\code{list}. Object containing data on the results of the optimization process.}
}
}

\section{Methods}{

\describe{
\item{print()}{
Print basic information of the model solution.}

\item{show()}{
Call print method.}

}
}

\examples{
\donttest{
# set seed for reproducibility
set.seed(14)

## Load data
data(sim_pu_data, sim_features_data, sim_dist_features_data,
sim_threats_data, sim_dist_threats_data, sim_sensitivity_data,
sim_boundary_data)

## Create data instance
problem_data <- inputData(
  pu = sim_pu_data, features = sim_features_data, dist_features = sim_dist_features_data,
  threats = sim_threats_data, dist_threats = sim_dist_threats_data,
  sensitivity = sim_sensitivity_data, boundary = sim_boundary_data
)

## Create optimization model
problem_model <- problem(x = problem_data, blm = 1)

## Solve the optimization model
s <- solve(a = problem_model, time_limit = 5, output_file = FALSE, cores = 2)

## Use class methods

s$print()
}

}
