% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameters.R
\name{matrix_parameters}
\alias{matrix_parameters}
\alias{numeric_matrix_parameter}
\alias{binary_matrix_parameter}
\title{Matrix parameters}
\usage{
numeric_matrix_parameter(name, value, lower_limit = .Machine$double.xmin,
  upper_limit = .Machine$double.xmax, symmetric = FALSE)

binary_matrix_parameter(name, value, symmetric = FALSE)
}
\arguments{
\item{name}{\code{character} name of parameter.}

\item{value}{\code{matrix} object.}

\item{lower_limit}{\code{numeric} values denoting the minimum acceptable
value in the matrix. Defaults to the smallest possible number on the
system.}

\item{upper_limit}{\code{numeric} values denoting the maximum acceptable
value in the matrix. Defaults to the smallest possible number on the
system.}

\item{symmetric}{\code{logical} must the must be matrix be symmetric?
Defaults to \code{FALSE}.}
}
\value{
\code{\link{MiscParameter-class}} object.
}
\description{
Create a parameter that represents a matrix object.
}
\examples{
# create matrix
m <- matrix(runif(9), ncol = 3)
colnames(m) <- letters[1:3]
rownames(m) <- letters[1:3]

# create a numeric matrix parameter
p1 <- numeric_matrix_parameter("m", m)
print(p1) # print it
p1$get() # get value
p1$id # get id
p1$validate(m[, -1]) # check if parameter can be updated
p1$set(m + 1) # set parameter to new values
p1$print() # print it again

# create a binary matrix parameter
m <- matrix(round(runif(9)), ncol = 3)
colnames(m) <- letters[1:3]
rownames(m) <- letters[1:3]

# create a binary matrix parameter
p2 <- binary_matrix_parameter("m", m)
print(p2) # print it
p2$get() # get value
p2$id # get id
p2$validate(m[, -1]) # check if parameter can be updated
p2$set(m + 1) # set parameter to new values
p2$print() # print it again
}
