% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_shuffle_portfolio.R
\name{add_shuffle_portfolio}
\alias{add_shuffle_portfolio}
\title{Add a shuffle portfolio}
\usage{
add_shuffle_portfolio(
  x,
  number_solutions = 10L,
  threads = 1L,
  remove_duplicates = TRUE
)
}
\arguments{
\item{x}{\code{\link{ConservationProblem-class}} object.}

\item{number_solutions}{\code{integer} number of attempts to generate
different solutions. Defaults to 10.}

\item{threads}{\code{integer} number of threads to use for the generating
the solution portfolio. Defaults to 1.}

\item{remove_duplicates}{\code{logical} should duplicate solutions
be removed? Defaults to \code{TRUE}.}
}
\value{
\code{\link{ConservationProblem-class}} object with the portfolio
  added to it.
}
\description{
Generate a portfolio of solutions for a conservation planning
\code{\link{problem}} by randomly reordering the data prior to
solving the problem. This is recommended as a replacement for
\code{\link{add_top_portfolio}} when the \emph{Gurobi} software is not
available.
}
\details{
This strategy for generating a portfolio of solutions often
  results in different solutions, depending on optimality gap, but may
  return duplicate solutions. In general, this strategy is most effective
  when problems are quick to solve and multiple threads are available for
  solving each problem separately.
}
\examples{
# set seed for reproducibility
set.seed(500)

# load data
data(sim_pu_raster, sim_features, sim_pu_zones_stack, sim_features_zones)

# create minimal problem with shuffle portfolio
p1 <- problem(sim_pu_raster, sim_features) \%>\%
      add_min_set_objective() \%>\%
      add_relative_targets(0.2) \%>\%
      add_shuffle_portfolio(10, remove_duplicates = FALSE) \%>\%
      add_default_solver(gap = 0.2, verbose = FALSE)

\donttest{
# solve problem and generate 10 solutions within 20 \% of optimality
s1 <- solve(p1)

# plot solutions in portfolio
plot(stack(s1), axes = FALSE, box = FALSE)
}
# build multi-zone conservation problem with shuffle portfolio
p2 <- problem(sim_pu_zones_stack, sim_features_zones) \%>\%
      add_min_set_objective() \%>\%
      add_relative_targets(matrix(runif(15, 0.1, 0.2), nrow = 5,
                                  ncol = 3)) \%>\%
      add_binary_decisions() \%>\%
      add_shuffle_portfolio(10, remove_duplicates = FALSE) \%>\%
      add_default_solver(gap = 0.2, verbose = FALSE)

\donttest{
# solve the problem
s2 <- solve(p2)

# print solution
str(s2, max.level = 1)

# plot solutions in portfolio
plot(stack(lapply(s2, category_layer)), main = "solution", axes = FALSE,
     box = FALSE)
}
}
\seealso{
\code{\link{portfolios}}.
}
