% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eval_rare_richness_importance.R
\name{eval_rare_richness_importance}
\alias{eval_rare_richness_importance}
\alias{eval_rare_richness_importance,ConservationProblem,numeric-method}
\alias{eval_rare_richness_importance,ConservationProblem,matrix-method}
\alias{eval_rare_richness_importance,ConservationProblem,data.frame-method}
\alias{eval_rare_richness_importance,ConservationProblem,Spatial-method}
\alias{eval_rare_richness_importance,ConservationProblem,sf-method}
\alias{eval_rare_richness_importance,ConservationProblem,Raster-method}
\title{Evaluate solution importance using rarity weighted richness scores}
\usage{
eval_rare_richness_importance(x, solution, ...)

\S4method{eval_rare_richness_importance}{ConservationProblem,numeric}(x, solution, rescale, ...)

\S4method{eval_rare_richness_importance}{ConservationProblem,matrix}(x, solution, rescale, ...)

\S4method{eval_rare_richness_importance}{ConservationProblem,data.frame}(x, solution, rescale, ...)

\S4method{eval_rare_richness_importance}{ConservationProblem,Spatial}(x, solution, rescale, ...)

\S4method{eval_rare_richness_importance}{ConservationProblem,sf}(x, solution, rescale, ...)

\S4method{eval_rare_richness_importance}{ConservationProblem,Raster}(x, solution, rescale, ...)
}
\arguments{
\item{x}{\code{\link[=problem]{problem()}} (i.e. \code{\linkS4class{ConservationProblem}}) object.}

\item{solution}{\code{numeric}, \code{matrix}, \code{data.frame},
\code{\linkS4class{Raster}}, \code{\linkS4class{Spatial}},
or \code{\link[sf:sf]{sf::sf()}} object.
The argument should be in the same format as the planning unit cost
data in the argument to \code{x}.
See the Solution format section for more information.}

\item{...}{not used.}

\item{rescale}{\code{logical} flag indicating if replacement cost
values---excepting infinite (\code{Inf}) and zero values---should be
rescaled to range between 0.01 and 1. Defaults to \code{TRUE}.}
}
\value{
A \code{numeric}, \code{matrix}, \code{data.frame}
\code{\linkS4class{RasterLayer}}, \code{\linkS4class{Spatial}},
or \code{\link[sf:sf]{sf::sf()}} object containing the importance scores for each planning
unit in the solution. Specifically, the returned object is in the
same format as the planning unit data in the argument to \code{x}.
}
\description{
Calculate importance scores for planning units selected in a solution
using rarity weighted richness scores (based on Williams \emph{et al.} 1996).
This method is only recommended for large-scaled conservation
planning exercises (i.e. more than 100,000 planning units) where
importance scores cannot be calculated using other methods in a feasible
period of time. This is because rarity weighted richness scores cannot (i)
account for the cost of different planning units, (ii) account for multiple
management zones, and (iii) identify truly irreplaceable planning units---
unlike the replacement cost metric which does not suffer any of these
limitations.
}
\details{
Rarity weighted richness scores are calculated using the following
terms. Let \eqn{I} denote the set of planning units (indexed by
\eqn{i}), let \eqn{J} denote the set of conservation features (indexed by
\eqn{j}), let \eqn{r_{ij}} denote the amount of feature \eqn{j}
associated with planning unit \eqn{i}, and let \eqn{m_j} denote the
maximum value of feature \eqn{j} in \eqn{r_{ij}} in all planning units
\eqn{i \in I}. To calculate the rarity weighted richness (\emph{RWR}) for
planning unit \eqn{k}:

\deqn{
  \mathit{RWR}_{k} = \sum_{j}^{J} \frac{ \frac{r_{ik}}{m_j} }{
                                          \sum_{i}^{I}r_{ij}}
  }{
  RWRk = sum_j^J ( (rik / mj) / sum_i^I rij)
  }
}
\section{Solution format}{

Broadly speaking, the argument to \code{solution} must be in the same format as
the planning unit data in the argument to \code{x}.
Further details on the correct format are listed separately
for each of the different planning unit data formats:

\describe{

\item{\code{x} has \code{numeric} planning units}{The argument to \code{solution} must be a
\code{numeric} vector with each element corresponding to a different planning
unit. It should have the same number of planning units as those
in the argument to \code{x}. Additionally, any planning units missing
cost (\code{NA}) values should also have missing (\code{NA}) values in the
argument to \code{solution}.
}

\item{\code{x} has \code{matrix} planning units}{The argument to \code{solution} must be a
\code{matrix} vector with each row corresponding to a different planning
unit, and each column correspond to a different management zone.
It should have the same number of planning units and zones
as those in the argument to \code{x}. Additionally, any planning units
missing cost (\code{NA}) values for a particular zone should also have a
missing (\code{NA}) values in the argument to \code{solution}.
}

\item{\code{x} has \code{\linkS4class{Raster}} planning units}{The argument to \code{solution}
be a \code{\linkS4class{Raster}} object where different grid cells (pixels) correspond
to different planning units and layers correspond to
a different management zones. It should have the same dimensionality
(rows, columns, layers), resolution, extent, and coordinate reference
system as the planning units in the argument to \code{x}. Additionally,
any planning units missing cost (\code{NA}) values for a particular zone
should also have missing (\code{NA})  values in the argument to \code{solution}.
}

\item{\code{x} has \code{data.frame} planning units}{The argument to \code{solution} must
be a \code{data.frame} with each column corresponding to a different zone,
each row corresponding to a different planning unit, and cell values
corresponding to the solution value. This means that if a \code{data.frame}
object containing the solution also contains additional columns, then
these columns will need to be subsetted prior to using this function
(see below for example with \code{\link[sf:sf]{sf::sf()}} data).
Additionally, any planning units missing cost
(\code{NA}) values for a particular zone should also have missing (\code{NA})
values in the argument to \code{solution}.
}

\item{\code{x} has \code{\linkS4class{Spatial}} planning units}{The argument to \code{solution}
must be a \code{\linkS4class{Spatial}} object with each column corresponding to a
different zone, each row corresponding to a different planning unit, and
cell values corresponding to the solution value. This means that if the
\code{\linkS4class{Spatial}} object containing the solution also contains additional
columns, then these columns will need to be subsetted prior to using this
function (see below for example with \code{\link[sf:sf]{sf::sf()}} data).
Additionally, the argument to \code{solution} must also have the same
coordinate reference system as the planning unit data.
Furthermore, any planning units missing cost
(\code{NA}) values for a particular zone should also have missing (\code{NA})
values in the argument to \code{solution}.
}

\item{\code{x} has \code{\link[sf:sf]{sf::sf()}} planning units}{The argument to \code{solution} must be
a \code{\link[sf:sf]{sf::sf()}} object with each column corresponding to a different
zone, each row corresponding to a different planning unit, and cell values
corresponding to the solution value. This means that if the
\code{\link[sf:sf]{sf::sf()}} object containing the solution also contains additional
columns, then these columns will need to be subsetted prior to using this
function (see below for example).
Additionally, the argument to \code{solution} must also have the same
coordinate reference system as the planning unit data.
Furthermore, any planning units missing cost
(\code{NA}) values for a particular zone should also have missing (\code{NA})
values in the argument to \code{solution}.
}
}
}

\examples{
\dontrun{
# seed seed for reproducibility
set.seed(600)

# load data
data(sim_pu_raster, sim_pu_sf, sim_features)

# create minimal problem with raster planning units
p1 <- problem(sim_pu_raster, sim_features) \%>\%
      add_min_set_objective() \%>\%
      add_relative_targets(0.1) \%>\%
      add_binary_decisions() \%>\%
      add_default_solver(gap = 0, verbose = FALSE)

# solve problem
s1 <- solve(p1)

# print solution
print(s1)

# plot solution
plot(s1, main = "solution", axes = FALSE, box = FALSE)

# calculate importance scores
rwr1 <- eval_rare_richness_importance(p1, s1)

# print importance scores
print(rwr1)

# plot importance scores
plot(rwr1, main = "rarity weighted richness", axes = FALSE, box = FALSE)

# create minimal problem with polygon (sf) planning units
p2 <- problem(sim_pu_sf, sim_features, cost_column = "cost") \%>\%
      add_min_set_objective() \%>\%
      add_relative_targets(0.05) \%>\%
      add_binary_decisions() \%>\%
      add_default_solver(gap = 0, verbose = FALSE)

# solve problem
s2 <- solve(p2)

# print solution
print(s2)

# plot solution
plot(s2[, "solution_1"], main = "solution")

# calculate importance scores
rwr2 <- eval_rare_richness_importance(p2, s2[, "solution_1"])

# plot importance scores
plot(rwr2, main = "rarity weighted richness")
}

}
\references{
Williams P, Gibbons D, Margules C, Rebelo A, Humphries C, and Pressey RL
(1996) A comparison of richness hotspots, rarity hotspots and complementary
areas for conserving diversity using British birds.
\emph{Conservation Biology}, 10: 155--174.
}
\seealso{
\link{importance}.
}
