% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alpha.R
\name{clr_alpha}
\alias{clr_alpha}
\title{Sets alpha in color}
\usage{
clr_alpha(col, alpha = 0.5)
}
\arguments{
\item{col}{a color object or vector of any of the three kinds of R color
specifications, i.e., either a color name (as listed by colors()), a
hexadecimal string of the form "#rrggbb" or "#rrggbbaa" (see rgb), or a
positive integer i meaning palette()[i].}

\item{alpha}{Numeric between 0 and 1. 0 will result in full transparency and
1 results in no transparency.}
}
\value{
a colors object
}
\description{
Sets alpha in color
}
\examples{
plot(clr_alpha(rainbow(10), 0.5))

plot(clr_alpha(rainbow(10), 0.2))

plot(clr_alpha(rainbow(10), seq(0, 1, length.out = 10)))
}
