% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-pred.R
\name{locate-equivocal}
\alias{locate-equivocal}
\alias{is_equivocal}
\alias{which_equivocal}
\alias{any_equivocal}
\title{Locate equivocal values}
\usage{
is_equivocal(x)

which_equivocal(x)

any_equivocal(x)
}
\arguments{
\item{x}{A \code{class_pred} object.}
}
\value{
\code{is_equivocal()} returns a logical vector the same length as \code{x}
where \code{TRUE} means the value is equivocal.

\code{which_equivocal()} returns an integer vector specifying the locations
of the equivocal values.

\code{any_equivocal()} returns \code{TRUE} if there are any equivocal values.
}
\description{
These functions provide multiple methods of checking for equivocal values,
and finding their locations.
}
\examples{

x <- class_pred(factor(1:10), which = c(2, 5))

is_equivocal(x)

which_equivocal(x)

any_equivocal(x)

}
