% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cal-apply.R
\name{cal_apply}
\alias{cal_apply}
\alias{cal_apply.data.frame}
\alias{cal_apply.tune_results}
\alias{cal_apply.cal_object}
\title{Applies a calibration to a set of existing predictions}
\usage{
cal_apply(.data, object, pred_class = NULL, parameters = NULL, ...)

\method{cal_apply}{data.frame}(.data, object, pred_class = NULL, parameters = NULL, ...)

\method{cal_apply}{tune_results}(.data, object, pred_class = NULL, parameters = NULL, ...)

\method{cal_apply}{cal_object}(.data, object, pred_class = NULL, parameters = NULL, ...)
}
\arguments{
\item{.data}{An object that can process a calibration object.}

\item{object}{The calibration object (\code{cal_object}).}

\item{pred_class}{(Optional, classification only) Column identifier for the
hard class predictions (a factor vector). This column will be adjusted based
on changes to the calibrated probability columns.}

\item{parameters}{(Optional)  An optional tibble of tuning parameter values
that can be used to filter the predicted values before processing. Applies
only to \code{tune_results} objects.}

\item{...}{Optional arguments; currently unused.}
}
\description{
Applies a calibration to a set of existing predictions
}
\details{
\code{cal_apply()} currently supports data.frames only. It extracts the \code{truth} and
the estimate columns names from the calibration object.
}
\examples{

# ------------------------------------------------------------------------------
# classification example

w_calibration <- cal_estimate_logistic(segment_logistic, Class)

cal_apply(segment_logistic, w_calibration)
}
\seealso{
\url{https://www.tidymodels.org/learn/models/calibration/},
\code{\link[=cal_estimate_beta]{cal_estimate_beta()}}, \code{\link[=cal_estimate_isotonic]{cal_estimate_isotonic()}},
\code{\link[=cal_estimate_isotonic_boot]{cal_estimate_isotonic_boot()}}, \code{\link[=cal_estimate_linear]{cal_estimate_linear()}},
\code{\link[=cal_estimate_logistic]{cal_estimate_logistic()}}, \code{\link[=cal_estimate_multinomial]{cal_estimate_multinomial()}}
}
