% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{hrs}
\alias{hrs}
\title{Health-expenditure data}
\format{
\subsection{\code{hrs}}{

A data frame with 6,052 rows and 14 columns:
\describe{
\item{age}{Age (in years)}
\item{assets}{Total assets (in dollars); bottom-coded at $20,000}
\item{doctor_visits}{Number of doctor visits}
\item{drug_costs}{Drug costs (in dollars)}
\item{income}{Income (in dollars); bottom-coded at $5,000}
\item{hosp_nights}{Number of nights spent in hospital}
\item{ins_private}{1 if insurance is private or employee-provided, 0 otherwise}
\item{ins_medicare}{1 if insurance is Medicare, 0 otherwise}
\item{ins_medicaid}{1 if insurance is Medicaid, 0 otherwise}
\item{ins_none}{1 if no health insurance, 0 otherwise}
\item{male}{1 if male, 0 otherwise}
\item{medical_costs}{Total medical costs (in dollars)}
\item{nodrug_financial}{1 if did not take prescription drugs for financial reasons, 0 otherwise}
\item{outofpocket_costs}{Total out-of-pocket medical costs (in dollars)}
}
}
}
\source{
\url{https://journaldata.zbw.eu/dataset/on-the-distribution-and-dynamics-of-health-care-costs}
}
\usage{
hrs
}
\description{
Data on healthcare utilization and expenditures for adults 50 years and older in
the United States, taken from the Health and Retirement Study (HRS) and Asset and
Health Dynamics Among the Oldest Old (AHEAD). Data was originally used in the
paper "On the distribution and dynamics of health care costs" by Eric French and
John Bailey Jones, 2004, Journal of Applied Econometrics, 19: 705-721. This
dataset is restricted to non-married individuals in the year 2000.
}
\keyword{datasets}
