% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelsSummary.R
\name{modelsSummaryTable}
\alias{modelsSummaryTable}
\title{Make Summary Table for Model Coefficients}
\usage{
modelsSummaryTable(x = NULL, vanilla = TRUE, ...)
}
\arguments{
\item{x}{An object of class modelSummary}

\item{vanilla}{A logical}

\item{...}{further arguments to be passed to modelsSummary()}
}
\value{
A flextable
}
\description{
Make Summary Table for Model Coefficients
}
\examples{
\donttest{
fit1=lm(mpg~wt,data=mtcars)
fit2=lm(mpg~wt*hp,data=mtcars)
fit3=lm(mpg~wt*hp*am,data=mtcars)
labels=list(X="wt",W="hp",Y="mpg",Z="am")
x=modelsSummary(fit1,labels=labels)
modelsSummaryTable(x)
modelsSummary(list(fit1,fit2),labels=labels)
modelsSummaryTable(list(fit1,fit2),labels=labels,vanilla=FALSE)
x=modelsSummary(list(fit1,fit2,fit3),labels=labels)
modelsSummaryTable(x)
modelsSummaryTable(labels=labels,data=pmi)
}
}
