% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drawConcept.R
\name{drawConcept}
\alias{drawConcept}
\title{Draw Concept Diagram}
\usage{
drawConcept(
  labels,
  nodelabels = list(),
  vars = NULL,
  moderator = NULL,
  covar = NULL,
  nodemode = 1,
  xpos = c(0, 0.5),
  mpos = c(0.5, 0.9),
  ypos = c(1, 0.5),
  minypos = 0,
  maxypos = 0.6,
  node.pos = list(),
  serial = FALSE,
  parallel = FALSE,
  parallel2 = FALSE,
  parallel3 = FALSE,
  bmatrix = NULL,
  curved.arrow = NULL,
  segment.arrow = NULL,
  radx = 0.06,
  rady = 0.04,
  box.col = "white",
  palette = NULL,
  reverse = FALSE,
  xmargin = 0.02,
  ymargin = 0.02,
  showPos = FALSE,
  xinterval = NULL,
  yinterval = NULL,
  label.pos = 1,
  drawbox = FALSE
)
}
\arguments{
\item{labels}{A list}

\item{nodelabels}{A list}

\item{vars}{A list of triple moderators}

\item{moderator}{A list of modeators}

\item{covar}{A list of covariates}

\item{nodemode}{integer If 1, separate node name and node label}

\item{xpos}{The x and y position of X node. Default value is c(0,0.5)}

\item{mpos}{The x and y position of M node. Default value is c(0.5,0.9)}

\item{ypos}{The x and y position of Y node. Default value is c(1,0.5)}

\item{minypos}{minimal y position of X or W variables}

\item{maxypos}{maximal y position of X or W variables}

\item{node.pos}{A optional list of node position}

\item{serial}{Logical. If TRUE, serial variables are added}

\item{parallel}{logical If true, draw parallel multiple mediation model}

\item{parallel2}{logical If true, draw parallel2 multiple mediation model}

\item{parallel3}{logical If true, draw parallel3 multiple mediation model}

\item{bmatrix}{integer specifying causal relations among mediators}

\item{curved.arrow}{Optional numeric vector specifying curvedarrow}

\item{segment.arrow}{Optional numeric vector specifying segmentarrow}

\item{radx}{horizontal radius of the box.}

\item{rady}{vertical radius of the box.}

\item{box.col}{fill color of the box}

\item{palette}{character. palette name}

\item{reverse}{logical. Reverse palette or not.}

\item{xmargin}{horizontal margin between nodes}

\item{ymargin}{vertical margin between nodes}

\item{showPos}{logical If true print node position}

\item{xinterval}{numeric. Horizontal intervals among labels for nodes and nodes}

\item{yinterval}{numeric. Vertical intervals among labels for nodes and nodes}

\item{label.pos}{Integer Position of nodelabels. Choices are one of 1:2}

\item{drawbox}{logical If true, draw rectangle}
}
\description{
Draw Concept Diagram
}
\examples{
labels=list(X="estress",M="affect",Y="withdraw")
vars=list(name=list(c("tenure","age")),site=list(c("a","b")))
moderator=list(name=c("age","sex"),site=list(c("c"),c("b","c")),pos=c(1,2),
     arr.pos=list(c(0.3),c(0.3,0.7)))
drawConcept(labels=labels)
drawConcept(labels=labels,vars=vars,drawbox=TRUE)
drawConcept(labels=labels,moderator=moderator,drawbox=TRUE)
drawConcept(labels=labels,vars=vars,moderator=moderator,drawbox=TRUE)
labels=list(X="X",M=c("M1","M2","M3"),Y="Y")
drawConcept(labels=labels,serial=TRUE)
drawConcept(labels=labels,parallel=TRUE,bmatrix=c(1,1,0,1,0,0,1,1,1,1))
drawConcept(labels=labels,parallel2=TRUE,bmatrix=c(1,1,0,1,0,0,1,1,1,1))
labels=list(X="baby",M=c("wine","tent","sand"),Y="tile")
bmatrix=c(1,1,0,1,0,0,1,1,1,1)
drawConcept(labels=labels,parallel=TRUE,bmatrix=bmatrix)
moderator=list(name=c("milk","hair"),
  matrix=list(c(1,1,0,1,0,0,0,0,0,0),c(0,0,0,0,0,0,0,1,0,0)))
drawConcept(labels=labels,parallel=TRUE,bmatrix=bmatrix,moderator=moderator)
bmatrix=c(1,1,0,0,1,1,1,1,0,1)
moderator=list(name=c("milk","hair"),
            matrix=list(c(1,0,0,0,1,0,1,0,0,0),c(1,1,0,0,0,0,0,0,0,0)),
            pos=c(1,4))
node.pos=list(X=c(0,0.5),M1=c(0.3,0.9),M2=c(0.3,0.1),M3=c(0.7,0.9),
Y=c(1,0.5),W1=c(0.7,0.1),W2=c(0,0.9))
drawConcept(labels=labels,bmatrix=bmatrix,moderator=moderator,node.pos=node.pos)
labels=list(X="baby",M=c("wine","tent","sand"),Y="tile")
vars=list(name=list(c("milk","hair")),matrix=list(c(1,0,0,0,0,0,1,0,0,0)),pos=2)
bmatrix=c(1,1,0,1,0,0,1,1,1,1)
drawConcept(labels=labels,parallel=TRUE,bmatrix=bmatrix,vars=vars)
labels=list(X="X",M=c("M1","M2"),Y="Y")
vars=list(name=list(c("W","Z")),matrix=list(c(0,0,1,0,0,0)),pos=6)
bmatrix=c(1,1,1,1,1,1)
drawConcept(labels=labels,bmatrix=bmatrix,vars=vars,palette="Set3")
labels=list(X="X",M="M",Y="Y")
vars=list(name=list(c("W","Z")),site=list(c("a","c")),arr.pos=list(c(0.7,0.3)))
moderator=list(name=c("V","Q"),site=list(c("b","c"),c("c")),
   pos=c(2,5),arr.pos=list(c(0.3,0.7),0.5))
drawConcept(labels=labels,vars=vars,moderator=moderator,nodemode=2)
}
