% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_token_color.R
\name{add_token_color}
\alias{add_token_color}
\title{Adds a token color attribute}
\usage{
add_token_color(eventlog, attribute, color_attribute, palette = "YlOrBr",
  na.color = "red", color_mapping = scales::col_numeric(palette, eventlog
  \%>\% pull(`!!`(attr)), na.color = na.color))
}
\arguments{
\item{eventlog}{The source eventlog}

\item{attribute}{The source attribute to calculate the color on}

\item{color_attribute}{The target attribute to store the color information in}

\item{palette}{The palette to use with the default color mapping}

\item{na.color}{The color for NA values}

\item{color_mapping}{A function that takes the attribute and returns a color, the default is using scales::col_numeric.}
}
\description{
Adds a color attribute to an event log that can be used in combination with the \code{token_color} parameter of \code{\link{animate_process}}
}
\examples{
{
  # Load example event log
  library(eventdataR)

  # Add token color based on a numeric attribute
  add_token_color(patients, "time", "color")

  # Add token color based on a factor attribute
  add_token_color(patients, "employee", "color",
                color_mapping = scales::col_factor("Set3", patients$employee))
}

}
