% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_token_size.R
\name{add_token_size}
\alias{add_token_size}
\title{Adds a token size attribute}
\usage{
add_token_size(eventlog, attribute, size_attribute, min.size = 2,
  max.size = 8, na.size = 2, size_mapping = size_numeric(eventlog
  \%>\% pull(`!!`(attr)), min.size, max.size, na.size))
}
\arguments{
\item{eventlog}{The source eventlog}

\item{attribute}{The source attribute to calculate the size on}

\item{size_attribute}{The target attribute to store the size information in}

\item{min.size}{The minimum size}

\item{max.size}{The maximum size}

\item{na.size}{The size for NA values}

\item{size_mapping}{A function that takes the attribute and returns a size between min.size and max.size, the default is a linear transformation that only works for numeric attributes..}
}
\description{
Adds a size attribute to an event log that can be used in combination with the token_size parameter of \code{\link{animate_process}}
}
\examples{
{
  # Load example event log
  library(eventdataR)

  # Generate random numeric attribute
  patients$test <- rnorm(nrow(patients), 5)

  # Add token size based on a numeric attribute
  add_token_size(patients, "test", "size")

}

}
