% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_rules.R
\name{filter_rules}
\alias{filter_rules}
\title{Filter using declarative rules.}
\usage{
filter_rules(eventlog, ...)
}
\arguments{
\item{eventlog}{Eventlog object}

\item{...}{rules}
}
\value{
A filtered event log.
}
\description{
This function can be used to filter event data using declaritive rules. It needs an event log and a rule. Rules can be made with the following functions:
absent(),
and(),
contains(),
contains_between(),
contains_exactly(),
ends(),
precedence(),
response(),
responded_existence(),
starts(),
succession(),
xor().
}
\examples{
library(eventdataR)

# Filter where Blood test precedes MRI SCAN and Registration is the start of the case.
filter_rules(patients, precedence("Blood test","MRI SCAN"),
             starts("Registration"))

}
