% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prodigen.R
\name{prodigen}
\alias{prodigen}
\title{Create a project directory based on a template}
\usage{
prodigen(proj.type, proj.name = NULL, proj.path = getwd(),
  git.init = FALSE, packrat.init = FALSE)
}
\arguments{
\item{proj.type}{type of project to create, based on the templates found in
\code{\link[prodigenr]{list_templates}} function}

\item{proj.name}{name of the new project directory}

\item{proj.path}{location of where the new project will be created}

\item{git.init}{Logical, whether to initialize the new project with git}

\item{packrat.init}{Logical, whether to track the R package usage with
packrat.}
}
\value{
Creates a project directory with files and subdirectories
}
\description{
Create a project directory and associated files.
}
\details{
The main workhorse of the \pkg{prodigenr} package.  Creates a
project directory layout, with template files and helper scripts.
}
\examples{

\dontrun{
## Get a list of possible project templates
list_templates('projects')
# Create a project. Best done in a fresh R console.
prodigen('poster', 'poster', 'dev/', TRUE, FALSE)
prodigen('poster', 'poster', 'path/to/dir/', FALSE)
prodigen('poster', 'posterName', git.init = FALSE)
prodigen('slides', 'conference-presentation', packrat.init = FALSE)
prodigen('abstract', 'name', './', FALSE)
prodigen('manuscript', proj.path = './', git.init = TRUE)
}
}
\author{
Luke W. Johnston
}

