% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/handler_txtprogressbar.R
\name{handler_txtprogressbar}
\alias{handler_txtprogressbar}
\title{Progression Handler: Progress Reported as Plain Progress Bars (Text) in the Terminal}
\usage{
handler_txtprogressbar(
  char = "=",
  style = 3L,
  file = stderr(),
  intrusiveness = getOption("progressr.intrusiveness.terminal", 1),
  target = "terminal",
  ...
)
}
\arguments{
\item{char}{(character) The symbols to form the progress bar for
\code{\link[utils:txtProgressBar]{utils::txtProgressBar()}}. Contrary to \code{txtProgressBar()}, this handler
supports also ANSI-colored symbols.}

\item{style}{(integer) The progress-bar style according to
\code{\link[utils:txtProgressBar]{utils::txtProgressBar()}}.}

\item{file}{(connection) A \link[base:connections]{base::connection} to where output should be sent.}

\item{intrusiveness}{(numeric) A non-negative scalar on how intrusive
(disruptive) the reporter to the user.}

\item{target}{(character vector) Specifies where progression updates are
rendered.}

\item{\ldots}{Additional arguments passed to \code{\link[utils:txtProgressBar]{utils::txtProgressBar()}}
and \code{\link[=make_progression_handler]{make_progression_handler()}}.}
}
\description{
A progression handler for \code{\link[utils:txtProgressBar]{utils::txtProgressBar()}}.
}
\section{Appearance}{

Below are a few examples on how to use and customize this progress handler.
In all cases, we use \code{handlers(global = TRUE)}.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{handlers("txtprogressbar")
y <- slow_sum(1:25)
}\if{html}{\out{</div>}}

\if{html}{\figure{handler_txtprogressbar-default.svg}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{handlers(handler_txtprogressbar(style = 1L))
y <- slow_sum(1:25)
}\if{html}{\out{</div>}}

\if{html}{\figure{handler_txtprogressbar-style-1.svg}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{handlers(handler_txtprogressbar(style = 3L))
y <- slow_sum(1:25)
}\if{html}{\out{</div>}}

\if{html}{\figure{handler_txtprogressbar-style-3.svg}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{handlers(handler_txtprogressbar(char = "#"))
y <- slow_sum(1:25)
}\if{html}{\out{</div>}}

\if{html}{\figure{handler_txtprogressbar-char.svg}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{handlers(handler_txtprogressbar(char = "<>"))
y <- slow_sum(1:25)
}\if{html}{\out{</div>}}

\if{html}{\figure{handler_txtprogressbar-char-width-2.svg}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{handlers(handler_txtprogressbar(char = cli::col_red(cli::symbol$heart)))
y <- slow_sum(1:25)
}\if{html}{\out{</div>}}

\if{html}{\figure{handler_txtprogressbar-char-ansi.svg}}
}

\examples{
handlers("txtprogressbar")

with_progress({ y <- slow_sum(1:10) })
print(y)
}
