% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setup.R
\name{setup_projects}
\alias{setup_projects}
\title{Set up the projects folder}
\usage{
setup_projects(path, folder_name = "projects", overwrite = FALSE,
  make_directories = FALSE,
  .Renviron_path = fs::path_home_r(".Renviron"))
}
\arguments{
\item{path}{The file path of the \strong{directory inside of which} the user
would like the projects folder to be created. Do not include the name of
the projects folder itself (i.e., the value of the argument
\code{folder_name} below).}

\item{folder_name}{The name of the projects folder that will be created in
the directory specified by the argument \code{path} above. Defaults to
\code{"projects"}.}

\item{overwrite}{Logical indicating whether or not to abandon any previously
stored projects folders stored in the system.}

\item{make_directories}{Logical indicating whether or not the function should
write any directories specified in the \code{path} argument that don't
already exist.}

\item{.Renviron_path}{The full file path of the .Renviron file where the user
would like to store the \code{\link{projects_folder}()} path. Default is
the home .Renviron file. If the file doesn't exist it will be created.}
}
\value{
The project folder's path, invisibly. It will be \code{""} if it
  doesn't exist.
}
\description{
Creates or restores the projects folder at the user-specified path.
}
\details{
The \code{\link[=projects-package]{projects}} package remembers where the
\link[=projects_folder]{projects folder} is located by storing its file path
in a \link{.Renviron} file (the home .Renviron file by default). The entry is
named \code{PROJECTS_FOLDER_PATH}.

Note that changing the \code{.Renviron_path} argument may create an .Renviron
file that R will not notice or use. See \link{Startup} for more details.
}
\section{Default contents}{
 The \link[=projects_folder]{projects folder}
  automatically contains the subdirectories \emph{.metadata} and
  \emph{.template}, which are hidden by default on some operating systems.

  The \emph{.metadata} folder and its contents should \strong{never} be
  manually moved or modified.

  The \emph{.templates} will contain several templates that
  \code{\link{new_project}()} reads when creating a new project. Advanced
  users may edit these templates or add their own. See
  \code{\link{new_project}()} for details.
}

\section{Behavior when projects folder already exists}{
 If \code{overwrite =
  TRUE}, the function will run no matter what. Use with caution.

  If the user has a pre-existing \link[=projects_folder]{projects folder} and
  runs this command with the pre-existing projects folder's path, nothing
  will be deleted.

  \strong{Therefore}, if the user "broke" the projects folder (e.g., by
  deleting metadata; by changing the "PROJECTS_FOLDER_PATH" line in the
  \emph{.Renviron} file), the user can "fix" the projects folder to some
  degree by running this function with the folder's actual file path (e.g.,
  restore all default templates; restore missing metadata files).
}

\examples{
# This sequence is used in all other examples in this package.

# Back up old projects_folder()
old_path <- Sys.getenv("PROJECTS_FOLDER_PATH")

# This sets up an example projects_folder() in a temporary directory.
# It will not edit any of the user's .Renviron files.
setup_projects(path = tempdir(), .Renviron_path = fs::path_temp(".Renviron"))

# Cleanup
Sys.setenv(PROJECTS_FOLDER_PATH = old_path)
fs::file_delete(c(fs::path_temp("projects"), fs::path_temp(".Renviron")))
}
\seealso{
\code{\link{new_project}()} for information on templates

  \link{Startup} for more information on how \emph{.Renviron} files work.
}
