% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/listcol.R
\name{listcol_pivot}
\alias{listcol_pivot}
\title{Pivot list-column elements to indicator variables}
\usage{
listcol_pivot(data, col_name, regex = ".", transform_fx = identity,
  delete_orig = FALSE)
}
\arguments{
\item{data}{Dataframe containing a list column (e.g. an issues dataframe)}

\item{col_name}{Character string containing column name of list column (e.g. \code{labels_name} or \code{assignees_login})}

\item{regex}{Character string of regular expression to identify list items of interest (e.g. \code{"^priority:", "^(bug|feature)$"})}

\item{transform_fx}{Function to transform label name before converting to column (e.g. \code{sub(":", "_")})}

\item{delete_orig}{Logical denoting whether or not to delete original list column provided by \code{col_name}}
}
\value{
Dataframe additional logical columns denoting absence / presence of specified list-column elements
}
\description{
Some outputs of the \code{get_} and \code{parse_} functions contain list-columns (e.g. the labels column in the issues dataframe).
This is an efficient way to represent the provided information, but may make certain information seem slightly inaccessible. This
function allows users to "pivot" these list columns and instead create a seperate indicator variable to represent the presence
or absence of matches within the list column.
}
\details{
For example, if a repository tags issues with "priority:high", "priority:medium", and "priority:low" along with other labels,
this function could be used to create separate "high", "medium", and "low" columns to denote different issue severities. This
could be done with \code{listcol_pivot(data, "labels_name", "^priority:", function(x) sub("^priority:", ""))}
}
\examples{
\dontrun{
issues <- get_issues(repo)
issues_df <- parse_issues(issues)
listcol_pivot(issues_df,
  col_name = "labels_name",
  regex = "^priority:",
  transform_fx = function(x) paste0("label_",x),
  delete_orig = TRUE)
}
}
