% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plan-todo.R
\name{post_plan}
\alias{post_plan}
\title{Post plan (milestones + issues) to GitHub repository}
\usage{
post_plan(ref, plan, distinct = TRUE)
}
\arguments{
\item{ref}{Repository reference (list) created by \code{create_repo_ref()}}

\item{plan}{Plan list as read with \code{read_plan()}}

\item{distinct}{Logical value to denote whether issues with the same title
as a current open issue should be allowed. Passed to \code{get_issues()}}
}
\value{
Dataframe with numbers (identifiers) of posted milestones and issues and issue title
}
\description{
Post custom plans (i.e. create milestones and issues) based on yaml read in by
\code{read_plan}. Please see the "Building Custom Plans" vignette for details.
}
\examples{
\dontrun{
# This example uses example file included in pkg
# You should be able to run example as-is after creating your own repo reference
file_path <- system.file("extdata", "plan.yml", package = "projmgr", mustWork = TRUE)
my_plan <- read_plan(file_path)
post_plan(ref, my_plan)
}
}
\seealso{
Other plans and todos: \code{\link{post_todo}},
  \code{\link{read_plan}}, \code{\link{read_todo}},
  \code{\link{report_plan}}, \code{\link{report_todo}},
  \code{\link{template_yaml}}
}
\concept{plans and todos}
