% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelProteins.R
\name{test_models}
\alias{test_models}
\title{Test machine learning models on test data}
\usage{
test_models(
  model_list,
  split_df,
  type = "prob",
  save_confusionmatrix = FALSE,
  file_path = NULL,
  ...
)
}
\arguments{
\item{model_list}{A \code{model_list} object from performing
\code{train_models}.}

\item{split_df}{A \code{split_df} object from performing \code{split_data}.}

\item{type}{Type of output. Set \code{type} as "prob" (default) to output
class probabilities, and "raw" to output class predictions.}

\item{save_confusionmatrix}{Logical. If \code{TRUE}, a tab-delimited
text file ("Confusion_matrices.txt") with confusion matrices in the
long-form data format will be saved in the directory specified by
\code{file_path}.
See below for more details.}

\item{file_path}{A string containing the directory path to save the file.}

\item{...}{Additional arguments to be passed on to
\code{\link[stats:predict]{predict}}.}
}
\value{
\itemize{\item \code{probability_list}: If \code{type = "prob"}, a list of
data frames containing class probabilities for each method in the
\code{model_list} will be returned.
\item \code{prediction_list}: If \code{type = "raw"}, a list of factors
containing class predictions for each method will be returned.}
}
\description{
This function can be used to predict test data using models
generated by different machine learning algorithms
}
\details{
\itemize{\item \code{test_models} function uses
models obtained from \code{train_models} to predict a given test data set.
\item Setting \code{type = "raw"} is required to obtain confusion matrices.
\item Setting \code{type = "prob"} (default) will output a list of
probabilities that can be used to generate ROC curves using \code{roc_plot}.}
}
\examples{
\donttest{
## Create a model_df object
covid_model_df <- pre_process(covid_fit_df, covid_norm_df)

## Split the data frame into training and test data sets
covid_split_df <- split_data(covid_model_df)

## Fit models using the default list of machine learning (ML) algorithms
covid_model_list <- train_models(covid_split_df)

# Test a list of models on a test data set and output class probabilities,
covid_prob_list <- test_models(model_list = covid_model_list, split_df = covid_split_df)
}

\dontrun{
# Save confusion matrices in the working directory and output class predictions
covid_pred_list <- test_models(
  model_list = covid_model_list,
  split_df = covid_split_df,
  type = "raw",
  save_confusionmatrix = TRUE,
  file_path = "."
)
}

}
\seealso{
\itemize{
\item \code{split_df}
\item \code{train_models}
\item \code{\link[stats:predict]{predict}}
\item \code{\link[caret:confusionMatrix]{confusionMatrix}}
}
}
\author{
Chathurani Ranathunge
}
