% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/511.Error-Failure_LimitBased_ADJ_All.R
\name{errAAll}
\alias{errAAll}
\title{Calculates error, long term power and pass/fail criteria using 6 adjusted methods (Wald, Wald-T, Likelihood, Score, Logit-Wald, ArcSine)}
\usage{
errAAll(n, alp, h, phi, f)
}
\arguments{
\item{n}{- Number of trials}

\item{alp}{- Alpha value (significance level required)}

\item{h}{- Adding factor}

\item{phi}{- Null hypothesis value}

\item{f}{- Failure criterion}
}
\value{
A dataframe with
 \item{delalp}{ Delta-alpha is the increase of the nominal error with respect to real error}
 \item{theta}{ Long term power of the test}
 \item{Fail_Pass}{Fail/pass based on the input f criterion}
 \item{method}{Name of the method}
}
\description{
Calculates error, long term power and pass/fail criteria using 6 adjusted methods (Wald, Wald-T, Likelihood, Score, Logit-Wald, ArcSine)
}
\details{
Calculates  error, long term power and pass/fail
criteria using 6 adjusted methods (Wald, Wald-T, Likelihood, Score, Logit-Wald, ArcSine)
}
\examples{
n=20; alp=0.05;h=2; phi=0.99; f=-2
errAAll(n,alp,h,phi,f)
}
\seealso{
Other Error for adjusted methods: \code{\link{PloterrAAS}},
  \code{\link{PloterrAAll}}, \code{\link{PloterrALR}},
  \code{\link{PloterrALT}}, \code{\link{PloterrASC}},
  \code{\link{PloterrATW}}, \code{\link{PloterrAWD}},
  \code{\link{errAAS}}, \code{\link{errALR}},
  \code{\link{errALT}}, \code{\link{errASC}},
  \code{\link{errATW}}, \code{\link{errAWD}}
}
