## ------------------------------------------------------------------------
set.seed(12345)
N <- 100
X <- data.frame(a=(1:N), b=(1:N) * rnorm(N, 10, 0.1),
                c=(N:1), d=(N:1) * rnorm(N, 10, 1.0))

## ---- results = "hide"---------------------------------------------------
library(propr)
phi <- phit(X, symmetrize = TRUE)
rho <- perb(X, ivar = 0)

## ------------------------------------------------------------------------
rho99 <- rho[">", .99]
rho99@pairs

## ------------------------------------------------------------------------
rhoab <- subset(rho, select = c("a", "b"))
rhoab@matrix

## ------------------------------------------------------------------------
simplify(rho99)

## ---- eval = FALSE-------------------------------------------------------
#  set.seed(12345)
#  randomNum <- sample(1:1000, size = 200 * 22, replace = TRUE)
#  counts <- matrix(randomNum, nrow = 22, ncol = 200)
#  prop <- phit(counts, symmetrize = FALSE, iter = 50, iterSize = 50)
#  sum(prop$pval < .01)
#  sum(prop$fdr < .01)

## ---- results = "hide", fig.show = "hold", fig.keep = "last"-------------
plot(rho99)

## ------------------------------------------------------------------------
N <- 100
a <- seq(from = 5, to = 15, length.out = N)
b <- a * rnorm(N, mean = 1, sd = 0.1)
c <- rnorm(N, mean = 10)
d <- rnorm(N, mean = 10)
e <- rep(10, N)
X <- data.frame(a, b, c, d, e)

## ------------------------------------------------------------------------
Y <- X / rowSums(X) * abs(rnorm(N))

## ------------------------------------------------------------------------
all(round(X[, 2] / X[, 1] - Y[, 2] / Y[, 1], 5) == 0)

## ---- fig.show = "hold"--------------------------------------------------
pairs(X)
pairs(Y)

## ---- warning = FALSE----------------------------------------------------
cor(X)
cor(Y)

## ------------------------------------------------------------------------
propr:::proprVLR(Y[, 1:4])
propr:::proprVLR(X)

## ---- fig.show = "hold"--------------------------------------------------
pairs(propr:::proprCLR(Y[, 1:4]))
pairs(propr:::proprCLR(X))

## ------------------------------------------------------------------------
phit(Y[, 1:4])@matrix
phit(X)@matrix

## ------------------------------------------------------------------------
perb(Y[, 1:4])@matrix
perb(X)@matrix

## ------------------------------------------------------------------------
cor(Y)
perb(Y)@matrix

## ---- fig.show = "hold"--------------------------------------------------
pairs(propr:::proprALR(Y, ivar = 5))
pairs(X[, 1:4])

## ------------------------------------------------------------------------
perb(Y, ivar = 5)@matrix

## ------------------------------------------------------------------------
pairs(propr:::proprALR(X, ivar = 1))

## ------------------------------------------------------------------------
perb(X, ivar = 1)@matrix

## ------------------------------------------------------------------------
dendrogram(perb(X, ivar = 1))

## ------------------------------------------------------------------------
perb(Y[, 2:5], ivar = 4)@matrix
perb(X, ivar = 5)@matrix

