% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drc_4p.R
\name{drc_4p}
\alias{drc_4p}
\title{Dose response curve helper function}
\usage{
drc_4p(data, response, dose, log_logarithmic = TRUE, pb = NULL)
}
\arguments{
\item{data}{a data frame that contains at least the dose and response column the model should be fitted to.}

\item{response}{the name of the column that contains the response values.}

\item{dose}{the name of the column that contains the dose values.}

\item{log_logarithmic}{logical indicating if a logarithmic or log-logarithmic model is fitted.
If response values form a symmetric curve for non-log transformed dose values, a logarithmic model instead
of a log-logarithmic model should be used. Usually biological dose response data has a log-logarithmic distribution, which is the
reason this is the default. Log-logarithmic models are symmetric if dose values are log transformed.}

\item{pb}{progress bar object. This is only necessary if the function is used in an iteration.}
}
\value{
An object of class \code{drc}. If no fit was performed a character vector with content "no_fit".
}
\description{
This function peforms the four-parameter dose response curve fit. It is the helper function for the fit in the \code{fit_drc_4p} function.
}
