% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treatment_enrichment.R
\name{treatment_enrichment}
\alias{treatment_enrichment}
\title{Check treatment enrichment}
\usage{
treatment_enrichment(
  data,
  protein_id,
  is_significant,
  binds_treatment,
  treatment_name,
  plot = TRUE
)
}
\arguments{
\item{data}{A dataframe contains at least the input variables.}

\item{protein_id}{The name of the column containing the protein accession numbers.}

\item{is_significant}{The name of the column containing a logical indicating if the corresponding protein has a significantly changing peptide. The input data frame
may contain peptide level information with significance information. The function is able to extract protein level information from this.}

\item{binds_treatment}{The name of the column containing a logical indicating if the corresponding protein binds to the treatment. This information can be obtained
from different databases, e.g Uniprot.}

\item{treatment_name}{A character vector of the treatment name. It will be included in the plot title.}

\item{plot}{A logical indicating whether the result should be plotted or returned as a table.}
}
\value{
A bar plot displaying the percentage of all detect proteins and all significant proteins that bind to the treatment. A Fisher's exact test is performed to
calculate the significance of the enrichment in significant proteins compared to all proteins. The result is reported as a p-value. If \code{plot = FALSE} a contingency
table in long format is returned.
}
\description{
Check for an enrichment of proteins interacting with the treatment in significantly changing proteins as compared to all proteins.
}
\examples{
\dontrun{
treatment_enrichment(
  data,
  protein_id = pg_protein_accessions,
  is_significant = significant,
  binds_treatment = binds_metals,
  treatment = "Metals"
)
}
}
