/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.stream;

import com.qarks.util.ui.resources.ResourceKey;
import com.qarks.util.ui.resources.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class FileDownloader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unzipFile(File file) throws Exception {
        File file2 = file.getParentFile();
        ZipInputStream zipInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            ZipEntry zipEntry;
            zipInputStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(file)));
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                File file3 = new File(file2, zipEntry.getName());
                fileOutputStream = new FileOutputStream(file3);
                byte[] byArray = new byte[5000];
                int n = 0;
                while ((n = zipInputStream.read(byArray)) > -1) {
                    ((OutputStream)fileOutputStream).write(byArray, 0, n);
                }
            }
        }
        finally {
            if (zipInputStream != null) {
                zipInputStream.close();
            }
        }
    }

    public void downloadFile(String string, String string2, String string3) throws Exception {
        MonitorDialog monitorDialog = new MonitorDialog(string, string2, string3);
        monitorDialog.setAlwaysOnTop(true);
        monitorDialog.centerOnScreen();
    }

    private class DownloadThread
    extends Thread {
        private MonitorDialog monitor;
        private Exception lastException = null;
        private String dest;
        private String url;
        private InputStream is;
        private OutputStream os;
        private boolean cancelled = false;

        public DownloadThread(MonitorDialog monitorDialog, String string, String string2, boolean bl, String string3, String string4, String string5, String string6) {
            this.monitor = monitorDialog;
            this.dest = string;
            this.url = string2;
            if (bl) {
                System.setProperty("http.proxySet", "true");
                System.setProperty("http.proxyHost", string3);
                System.setProperty("http.proxyPort", string4);
                System.setProperty("http.proxyUser", string5);
                System.setProperty("http.proxyPassword", string6);
            } else {
                System.setProperty("http.proxySet", "false");
            }
        }

        private void setTotalSize(final int n) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DownloadThread.this.monitor.setTotalSize(n);
                }
            });
        }

        private void onDownloadProgress(final int n) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DownloadThread.this.monitor.onDownloadProgress(n);
                }
            });
        }

        private void onException(final Exception exception) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DownloadThread.this.monitor.onExceptionOccured(exception);
                }
            });
        }

        public void cancel() {
            this.cancelled = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                URL uRL = new URL(this.url);
                URLConnection uRLConnection = uRL.openConnection();
                uRLConnection.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; .NET CLR 2.0.50727)");
                uRLConnection.setConnectTimeout(15000);
                uRLConnection.setReadTimeout(15000);
                int n = uRLConnection.getContentLength();
                if (!this.cancelled) {
                    if (n == -1) {
                        System.out.println("size=-1");
                        throw new IOException(ResourceManager.getString((Object)ResourceKey.FILE_UNREACHABLE));
                    }
                    this.setTotalSize(n);
                    this.os = new BufferedOutputStream(new FileOutputStream(this.dest));
                    this.is = uRLConnection.getInputStream();
                    byte[] byArray = new byte[5000];
                    int n2 = 0;
                    int n3 = 0;
                    while (!this.cancelled && (n2 = this.is.read(byArray)) > -1) {
                        n3 += n2;
                        this.os.write(byArray, 0, n2);
                        this.onDownloadProgress(n2);
                    }
                    if (n3 < n) {
                        this.lastException = new IOException(ResourceManager.getString((Object)ResourceKey.UNEXPECTED_LENGTH));
                        this.onException(this.lastException);
                    } else {
                        this.monitor.onFinish();
                    }
                } else {
                    this.lastException = new IOException(ResourceManager.getString((Object)ResourceKey.DOWNLOAD_CANCELLED));
                }
            }
            catch (Exception exception) {
                this.lastException = exception;
                this.onException(this.lastException);
            }
            finally {
                if (this.is != null) {
                    try {
                        this.is.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                if (this.os != null) {
                    try {
                        this.os.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        }
    }

    private class MonitorDialog
    extends JDialog
    implements ActionListener {
        private String dest;
        private String url;
        private JButton retry;
        private JButton cancel;
        private JProgressBar progress;
        private JLabel infoLabel;
        private JTextField proxy;
        private JTextField port;
        private JTextField login;
        private JPasswordField password;
        private JCheckBox usesProxy;
        private DownloadThread downloadThread;
        private JPanel proxyPanel;

        public MonitorDialog(String string, String string2, String string3) {
            super(new Frame(), ResourceManager.getString((Object)ResourceKey.DOWNLOADING, string3), true);
            this.dest = string;
            this.url = string2;
            Container container = this.getContentPane();
            container.setLayout(new GridLayout(1, 1));
            this.progress = new JProgressBar();
            this.progress.setPreferredSize(new Dimension(300, 30));
            this.infoLabel = new JLabel();
            this.proxy = new JTextField(20);
            this.port = new JTextField(20);
            this.login = new JTextField(20);
            this.password = new JPasswordField(20);
            this.usesProxy = new JCheckBox(ResourceManager.getString((Object)ResourceKey.USES_PROXY));
            this.retry = new JButton(ResourceManager.getString((Object)ResourceKey.RETRY));
            this.retry.addActionListener(this);
            this.retry.setEnabled(false);
            this.cancel = new JButton(ResourceManager.getString((Object)ResourceKey.CANCEL));
            this.cancel.addActionListener(this);
            JPanel jPanel = new JPanel(new GridLayout(1, 2, 5, 5));
            jPanel.add(this.cancel);
            jPanel.add(this.retry);
            JPanel jPanel2 = new JPanel(new BorderLayout(5, 5));
            jPanel2.add((Component)this.progress, "North");
            jPanel2.add((Component)this.infoLabel, "Center");
            jPanel2.add((Component)jPanel, "South");
            this.proxyPanel = new JPanel(new GridLayout(5, 2, 5, 5));
            this.proxyPanel.add((Component)this.usesProxy, 0);
            this.proxyPanel.add((Component)new JLabel(""), 1);
            this.proxyPanel.add((Component)new JLabel(ResourceManager.getString((Object)ResourceKey.PROXY)), 2);
            this.proxyPanel.add((Component)this.proxy, 3);
            this.proxyPanel.add((Component)new JLabel(ResourceManager.getString((Object)ResourceKey.PORT)), 4);
            this.proxyPanel.add((Component)this.port, 5);
            this.proxyPanel.add((Component)new JLabel(ResourceManager.getString((Object)ResourceKey.LOGIN)), 6);
            this.proxyPanel.add((Component)this.login, 7);
            this.proxyPanel.add((Component)new JLabel(ResourceManager.getString((Object)ResourceKey.PASSWORD)), 8);
            this.proxyPanel.add((Component)this.password, 9);
            this.proxyPanel.setVisible(false);
            JPanel jPanel3 = new JPanel(new BorderLayout(5, 5));
            jPanel3.setBorder(new EmptyBorder(10, 10, 10, 10));
            jPanel3.add((Component)jPanel2, "North");
            jPanel3.add((Component)this.proxyPanel, "South");
            container.add(jPanel3);
            this.pack();
            this.startDownload();
        }

        public void centerOnScreen() throws Exception {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation((int)(dimension.getWidth() - (double)this.getWidth()) / 2, (int)(dimension.getHeight() - (double)this.getHeight()) / 2);
            this.setVisible(true);
            if (this.downloadThread.lastException != null) {
                throw this.downloadThread.lastException;
            }
        }

        private void setTotalSize(int n) {
            this.progress.setMaximum(n);
            double d = (double)n / 1048576.0;
            d = (double)((int)(d * 100.0)) / 100.0;
            this.infoLabel.setText("<html><font color=\"#000000\">Download size: " + d + "Mo</font></html>");
        }

        private void onDownloadProgress(int n) {
            this.progress.setValue(this.progress.getValue() + n);
        }

        private void onExceptionOccured(Exception exception) {
            this.retry.setEnabled(true);
            this.cancel.setEnabled(false);
            this.infoLabel.setText("<html><font color=\"#FF0000\">" + exception.getMessage() + "</font></html>");
            this.proxyPanel.setVisible(true);
            this.pack();
        }

        private void onFinish() {
            if (this.dest.toLowerCase().endsWith(".zip")) {
                File file = new File(this.dest);
                try {
                    this.infoLabel.setText("<html><font color=\"#000000\">" + ResourceManager.getString((Object)ResourceKey.UNZIPPING) + "</font></html>");
                    FileDownloader.this.unzipFile(file);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    this.onExceptionOccured(exception);
                }
            }
            this.dispose();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.retry) {
                this.startDownload();
            } else if (object == this.cancel) {
                this.cancel.setEnabled(false);
                this.retry.setEnabled(true);
                this.downloadThread.cancel();
                this.proxyPanel.setVisible(true);
                this.pack();
            }
        }

        private void startDownload() {
            this.progress.setValue(0);
            this.retry.setEnabled(false);
            this.downloadThread = new DownloadThread(this, this.dest, this.url, this.usesProxy.isSelected(), this.proxy.getText(), this.port.getText(), this.login.getText(), this.password.getText());
            this.downloadThread.start();
            this.cancel.setEnabled(true);
        }
    }
}

