/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.ui.lookandfeel;

import com.l2fprod.gui.plaf.skin.Skin;
import com.l2fprod.gui.plaf.skin.SkinLookAndFeel;
import com.l2fprod.util.OS;
import com.qarks.util.ui.lookandfeel.BorderedCheckBoxUI;
import com.qarks.util.ui.lookandfeel.BorderedRadioButtonUI;
import com.qarks.util.ui.lookandfeel.ExtendedListUI;
import com.qarks.util.ui.lookandfeel.ExtendedTableUI;
import com.qarks.util.ui.lookandfeel.ExtendedToolBarUI;
import com.qarks.util.ui.lookandfeel.ExtendedTreeUI;
import com.sun.java.swing.plaf.windows.WindowsScrollBarUI;
import java.awt.Toolkit;
import java.lang.reflect.Method;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicRootPaneUI;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class LookAndFeelChooser {
    public static final String SYSTEM = "System";
    private static String currentLookAndFeel;

    public static String getCurrentLookName() {
        return currentLookAndFeel;
    }

    public static void loadLookAndFeel() {
        LookAndFeelChooser.applyUIFixes();
        boolean bl = "true".equals(System.getProperty("skin.skinLF.enabled", "true"));
        if (bl) {
            String string = System.getProperty("skin.skinLF.name", SYSTEM);
            if (SYSTEM.equals(string)) {
                LookAndFeelChooser.selectSystemLookAndFeel();
            } else {
                LookAndFeelChooser.loadLookAndFeel(string);
            }
        }
    }

    public static void selectSystemLookAndFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void applyUIFixes() {
        boolean bl;
        ToolTipManager.sharedInstance().setInitialDelay(1000);
        ToolTipManager.sharedInstance().setReshowDelay(5000);
        UIManager.put("ListUI", ExtendedListUI.class.getName());
        UIManager.put("TableUI", ExtendedTableUI.class.getName());
        UIManager.put("TreeUI", ExtendedTreeUI.class.getName());
        UIManager.put("ToolBarUI", ExtendedToolBarUI.class.getName());
        UIManager.put("SplitPane.dividerSize", new Integer(10));
        boolean bl2 = "true".equals(System.getProperty("skin.undecorated", "false"));
        if (bl2) {
            if (OS.isOneDotFourOrMore()) {
                try {
                    Method method = JFrame.class.getMethod("setDefaultLookAndFeelDecorated", Boolean.TYPE);
                    method.invoke(null, Boolean.TRUE);
                    method = JDialog.class.getMethod("setDefaultLookAndFeelDecorated", Boolean.TYPE);
                    method.invoke(null, Boolean.TRUE);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        } else {
            UIManager.put("RootPaneUI", BasicRootPaneUI.class.getName());
        }
        if (bl = "true".equals(System.getProperty("skin.noerase", "false"))) {
            System.setProperty("sun.awt.noerasebackground", "true");
        }
        boolean bl3 = "true".equals(System.getProperty("skin.dynamicLayout", "true"));
        Toolkit.getDefaultToolkit().setDynamicLayout(bl3);
    }

    public static void loadLookAndFeel(String string) {
        boolean bl = "true".equals(System.getProperty("skin.skinLF.enabled", "true"));
        if (bl) {
            try {
                SkinLookAndFeel.setSkin((Skin)SkinLookAndFeel.loadThemePack((String)string));
                UIManager.setLookAndFeel("com.l2fprod.gui.plaf.skin.SkinLookAndFeel");
                boolean bl2 = "true".equals(System.getProperty("skin.splitpane.basic", "true"));
                if (bl2) {
                    UIManager.put("SplitPaneUI", BasicSplitPaneUI.class.getName());
                }
                UIManager.put("RadioButtonUI", BorderedRadioButtonUI.class.getName());
                UIManager.put("CheckBoxUI", BorderedCheckBoxUI.class.getName());
                boolean bl3 = "true".equals(System.getProperty("skin.scrollbar.native", "false"));
                if (bl3) {
                    UIManager.put("ScrollBarUI", WindowsScrollBarUI.class.getName());
                }
                currentLookAndFeel = string;
            }
            catch (Exception exception) {
                currentLookAndFeel = "default";
                exception.printStackTrace();
            }
        }
    }
}

