% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/provenance.R
\name{summaryplot}
\alias{summaryplot}
\title{Joint plot of several provenance datasets}
\usage{
summaryplot(..., ncol = 1)
}
\arguments{
\item{...}{a sequence of datasets of class \code{HMdata},
\code{KDEs}, or \code{DZdata}}

\item{ncol}{the number of columns}
}
\value{
a summary plot of all the data comprised of KDEs for the
datasets of class \code{KDEs}, pie charts for those of class
\code{HMdata} and histograms for those of class \code{DZdata}.
}
\description{
Arranges kernel density estimates and pie charts in a grid format
}
\examples{
DZ <- read.DZdata(system.file("DZ.csv",package="provenance"))
KDEs <- getKDEs(DZ,0,3000)
HM <- read.HMdata(system.file("HM.csv",package="provenance"))
PT <- read.HMdata(system.file("PT.csv",package="provenance"))
summaryplot(KDEs,HM,PT,ncol=2)
}

