% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotatePeptides.R
\name{annotateAHO}
\alias{annotateAHO}
\title{annotate peptides using AhoCorasickTrie}
\usage{
annotateAHO(pepseq, fasta)
}
\arguments{
\item{pepseq}{- list of peptides - sequence, optional modified sequence, charge state.}

\item{fasta}{- object as created by readPeptideFasta}
}
\description{
peptides which do not have protein assignment drop out
}
\examples{

library(prozor)
file = system.file("extdata/shortfasta.fasta.gz",package = "prozor")
fasta = readPeptideFasta(file = file)
pepprot <- get(data("pepprot", package = "prozor"))
system.time( res2 <- annotateAHO( pepprot[1:20,"peptideSeq"], fasta))
colnames(res2)
}
