% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/low-level.R
\name{ps_kill}
\alias{ps_kill}
\title{Kill a process}
\usage{
ps_kill(p)
}
\arguments{
\item{p}{Process handle.}
}
\description{
Kill the current process with SIGKILL pre-emptively checking
whether PID has been reused. On Windows it uses \code{TerminateProcess()}.
}
\seealso{
Other process handle functions: \code{\link{ps_children}},
  \code{\link{ps_cmdline}}, \code{\link{ps_cpu_times}},
  \code{\link{ps_create_time}}, \code{\link{ps_cwd}},
  \code{\link{ps_environ}}, \code{\link{ps_exe}},
  \code{\link{ps_handle}}, \code{\link{ps_is_running}},
  \code{\link{ps_memory_info}}, \code{\link{ps_name}},
  \code{\link{ps_num_threads}}, \code{\link{ps_pid}},
  \code{\link{ps_ppid}}, \code{\link{ps_resume}},
  \code{\link{ps_send_signal}}, \code{\link{ps_status}},
  \code{\link{ps_suspend}}, \code{\link{ps_terminal}},
  \code{\link{ps_terminate}}, \code{\link{ps_uids}},
  \code{\link{ps_username}}
}
\section{Examples}{
\Sexpr[stage=install,strip.white=FALSE,results=rd]{
ps:::decorate_examples(os = "POSIX",  '
px <- processx::process$new("sleep", "10")
p <- ps_handle(px$get_pid())
p
ps_kill(p)
p
ps_is_running(p)
px$get_exit_status()
')}
}
