% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Getters.R
\name{PolityGet}
\alias{PolityGet}
\title{Downloads Polity IV}
\usage{
PolityGet(url = "http://www.systemicpeace.org/inscr/p4v2012.sav",
  vars = NULL, OutCountryID = "iso2c", standardCountryName = TRUE,
  na.rm = TRUE, duplicates = "message", fromLast = FALSE)
}
\arguments{
\item{url}{character string. The URL for the Polity IV data set you would
like to download. Note: it must be for the SPSS version of the file.}

\item{vars}{character vector containing the variables to keep. If
\code{vars = NULL} then the entire data set is returned. Note that the
\code{country} and \code{year} variables are always returned.}

\item{OutCountryID}{character string. The type of country ID you would like
to include in the output file along with the country name. See
\code{\link{countrycode}} for available options.}

\item{standardCountryName}{logical. Whether or not to standardise the country
names variable based on \code{country.name} from  \code{\link{countrycode}}.}

\item{na.rm}{logical. Drop observations where \code{OutCountryID} is
\code{NA}.}

\item{duplicates}{character specifying how to handle duplicated country-year
observations. Can be set to \code{none} to do nothing, \code{message} to
simply report duplicates, \code{drop} to report and drop duplicates, and
\code{return} to return a data frame with only duplicated observations
(see also \code{fromLast}).}

\item{fromLast}{logical indicating if duplication should be considered
from the reverse side. Only relevant if \code{duplicates = 'drop'} or
\code{duplicates = 'out'}.}
}
\value{
a data frame
}
\description{
Downloads the Polity IV data set. It keeps specified variables and creates a
standard country ID variable that can be used for merging the data with other
data sets.
}
\examples{
\dontrun{
# Download full data set
PolityData <- PolityGet()

# Create data frame with only the main Polity democracy variable (polity2)
Polity2Data <- PolityGet(vars = 'polity2',
                         OutCountryID = 'imf')
}

}
\seealso{
\code{\link{countrycode}}, \code{\link{CountryID}},
\code{\link{WinsetCreator}}
}

