% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factor_reorder_function.R
\name{reorder_factors}
\alias{reorder_factors}
\title{Reorder factors}
\usage{
reorder_factors(data, sheet)
}
\arguments{
\item{data}{Harmonization object, or harmonized data.frame.}

\item{sheet}{Factor reorder sheet.}
}
\value{
Returns harmonization object, or harmonized data.frame.
}
\description{
Reorder factors
}
\examples{

# Running harmonization function with example harmonization sheet
harmonization_obj <- harmonization(harmonization_sheet = harmonization_sheet_example)

long_dataset <- harmonization_obj$long_dataset

table(long_dataset$education)

# College
# 5643
#
# Graduate/Professional
# 1287
#
# High school
# 7562
#
# No education/grade school
# 7508

# Creating factor reorder sheet
edu_order <- data.frame(
 variable = 'education',
 values = c('No education/grade school', 'High school', 'College', 'Graduate/Professional'),
 order = 1:4
)

# Reorder factors
harmonization_obj <- reorder_factors(data = harmonization_obj, sheet = edu_order)

long_dataset <- harmonization_obj$long_dataset

table(long_dataset$education)

# No education/grade school
# 7508
#
# High school
# 7562
#
# College
# 5643
#
# Graduate/Professional
# 1287


}
