% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.psbcSpeedUp.R
\name{coef.psbcSpeedUp}
\alias{coef.psbcSpeedUp}
\title{coef method for class \code{psbcSpeedUp}}
\usage{
\method{coef}{psbcSpeedUp}(object, type = "mean", ...)
}
\arguments{
\item{object}{an object of class \code{psbcSpeedUp}}

\item{type}{type of point estimates of regressions. One of
\code{c("mean", "median")}. Default is \code{mean}}

\item{...}{not used}
}
\value{
Estimated coefficients are from an object of class \code{psbcSpeedUp}.
If the \code{psbcSpeedUp} specified data standardization, the fitted values
are base based on standardized data.
}
\description{
Extract the point estimates of the regression coefficients
}
\examples{

# Load the example dataset
data("exampleData", package = "psbcSpeedUp")
p <- exampleData$p
q <- exampleData$q
survObj <- exampleData[1:3]

# Set hyperparameters
mypriorPara <- list(
  "groupInd" = 1:p, "eta0" = 0.02, "kappa0" = 1, "c0" = 2, "r" = 10 / 9, 
  "delta" = 1e-05, "lambdaSq" = 1, "sigmaSq" = runif(1, 0.1, 10), 
  "beta.prop.var" = 1, "beta.clin.var" = 1)

# run Bayesian Lasso Cox
library(psbcSpeedUp)
set.seed(123)
fitBayesCox <- psbcSpeedUp(survObj,
  p = p, q = q, hyperpar = mypriorPara,
  nIter = 10, burnin = 0, outFilePath = tempdir()
)
coef(fitBayesCox)

}
