% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prior_poisson.R
\docType{class}
\name{PriorPoisson-class}
\alias{PriorPoisson-class}
\alias{.prior_poisson}
\title{\code{PriorPoisson} Class}
\description{
A class for defining poisson priors to be translated to Stan code.
Objects of class \code{PriorPoisson} should not be created directly but by
the constructor \code{\link[=prior_poisson]{prior_poisson()}}.
}
\section{Slots}{

\describe{
\item{\code{stan_code}}{character. Stan implementation of the prior, with
placeholders for poisson stan function parameters surrounded with
\verb{\{\{} and \verb{\}\}} to be replaced with \code{\link[glue:glue]{glue::glue()}}.}

\item{\code{n_param}}{integer. Number of prior parameters (1).}

\item{\code{constraint}}{character. Support of prior distribution,
\code{"<lower=0>"}.}

\item{\code{lambda}}{numeric. Rate (>0).}
}}

\seealso{
Other prior classes: 
\code{\link{Prior-class}},
\code{\link{PriorBernoulli-class}},
\code{\link{PriorBeta-class}},
\code{\link{PriorCauchy-class}},
\code{\link{PriorExponential-class}},
\code{\link{PriorGamma-class}},
\code{\link{PriorHalfCauchy-class}},
\code{\link{PriorHalfNormal-class}},
\code{\link{PriorNormal-class}},
\code{\link{UniformPrior-class}}
}
\concept{prior classes}
