% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_data_list.R
\docType{class}
\name{SimDataList-class}
\alias{SimDataList-class}
\alias{.sim_data_list}
\title{\code{SimDataList} Class}
\description{
A class for defining generated data for use as part of a
simulation study. Objects of class \code{SimDataList} should not be created
directly but by the constructor \code{sim_data_list()}.
}
\section{Slots}{

\describe{
\item{\code{data_list}}{list of lists of matrices. The lists at the highest
level differ in that the parameters used to generate the data. The matrices
at lowest level are different iterations of the same data generation
parameters.}

\item{\code{guide}}{data.frame. \code{guide} contains information on the parameters
that differ at the highest level of \code{data_list}.}

\item{\code{effect}}{character. The column in \code{guide} that
corresponds to the true treatment effect estimate (hazard ratio or odds ratio).}

\item{\code{drift}}{character. The column in \code{guide} that
corresponds to the drift between external and internal control arms. A
drift >1 means the external arm experiences greater effects.}

\item{\code{index}}{character. The column in \code{guide} that corresponds
to the index of the parameter situations in \code{data_list}.}
}}

