% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surv.mod.R
\docType{data}
\name{surv.mod}
\alias{surv.mod}
\title{Example model for a survival outcome}
\format{
A model of class 'flezsurvreg':
\describe{
 \item{gamma}{cumulative baseline hazard parameters}
 \item{vi}{vascular invasion}
 \item{age60}{patient age (centred at 60)}
 \item{ecog}{ECOG performance Status}
 \item{logafp}{AFP - log scale}
 \item{alb}{albumin}
 \item{logcreat}{Creatinine - log scale}
 \item{allmets}{metastesis}
 \item{ageVasInv}{centred age nested within vascular invasion}
 \item{time}{survival time}
 \item{cen}{censoring indicator}
 \item{os}{survival time}
 \item{count}{exapmple outcome for count data}
 \item{trt}{exapmple identifier for mulitple treatment comparisons}
 \item{aet}{Aetiology}
}
}
\source{
simulated
}
\usage{
surv.mod
}
\description{
A generated model with a survival endpoint and a cuymulative hazard function
estimated using flexible parametric splines. Data for the model were
synthetically generated and are based on a dataset to
evaulate the use of Sorafenib in HCC akin to the PROSASH model
}
\references{
Using prognostic and predictive clinical features to make
personalised survival prediction in advanced hepatocellular carcinoma patients
undergoing sorafenib treatment. Berhane S, et al., Br J Cancer. 2019 Jul;121(2):117-124
}
\keyword{datasets}
