% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ottawa_db_shp}
\alias{ottawa_db_shp}
\title{2021 Statistics Canada Dissemination Block Boundaries and Populations for Ottawa, Ontario}
\format{
A data frame with class sf in CRS NAD/MTM zone 9 (32189) and 8,559 rows and 3 variables:
\describe{
   \item{DBUID}{Unique dissemination block identifier}
   \item{dbpop2021}{Dissemination block population as given in the 2021
       Statistics Canada geographic attribute file,
     \url{https://www12.statcan.gc.ca/census-recensement/2021/geo/aip-pia/attribute-attribs/index2021-eng.cfm}}
   \item{geometry}{MULTIPOLYGON defining DB geometry}
}

This data is licensed under the Statistics Canada Open Data License
(\url{https://www.statcan.gc.ca/en/reference/licence}).
Adapted from Statistics Canada, 2021 Dissemination Block Boundary File,
2022-09-19, and Statistics Canada, 2021 Census – Geographic Attribute File,
2022-02-10.
This does not constitute an endorsement by Statistics Canada of this product.
}
\usage{
ottawa_db_shp
}
\description{
Spatial dataset for dissemination blocks (DBs) in Ottawa, Ontario, provided by
Statistics Canada, \url{https://www12.statcan.gc.ca/census-recensement/2021/geo/sip-pis/boundary-limites/index2021-eng.cfm?year=21}.
}
\details{
Dissemination blocks are the smallest unit of geography at which Statistics
Canada publishes population data. DBs are generally bounded by road segments
or natural features like waterways. In urban areas DBs are generally the size
of a city block, but in rural areas they can be much larger.
}
\keyword{datasets}
