% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build.panel.r
\name{getNamesPSID}
\alias{getNamesPSID}
\title{GetPSID variables names from various years}
\usage{
getNamesPSID(aname, cwf, years = NULL, file = NULL)
}
\arguments{
\item{aname}{A variable name in any of the PSID years}

\item{cwf}{A data.frame representation of the cross-walk file,
(the psid.xlsx file).}

\item{years}{A vector of years. If NULL, all years in which that
variable existed are returned}

\item{file}{optional file name to write csv}
}
\value{
A vector of names, one for each year.
}
\description{
The user can specify one variable name from any year. This function
will find that variable's correct name in any of the years
specified by the user. If user does not specify the \code{years}
variable, return will represent all years in which variable was
present.
}
\details{
This uses the psid.xlsx crosswalk file from UMich, which is
available at http://psidonline.isr.umich.edu/help/xyr/psid.xlsx. In the 
example, the package openxlsx's read.xlsx is used to import the crosswalk
file.

Ask for one variable at a time.
}
\examples{
# read UMich crosswalk from installed file
r = system.file(package="psidR")
cwf = openxlsx::read.xlsx(file.path(r,"psid-lists","psid.xlsx"))

# or download directly
# cwf <- read.xlsx("http://psidonline.isr.umich.edu/help/xyr/psid.xlsx")

# then get names with
getNamesPSID("ER17013", cwf, years = 2001)
getNamesPSID("ER17013", cwf, years = 2003)
getNamesPSID("ER17013", cwf, years = NULL)
getNamesPSID("ER17013", cwf, years = c(2005, 2007, 2009))
}
\author{
Paul Johnson <pauljohn@ku.edu>
}
