% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitting.R
\name{fit_ends_mods_par}
\alias{fit_ends_mods_par}
\title{Fit multiple parametric survival regressions to the multiple required endpoints}
\usage{
fit_ends_mods_par(
  simdat,
  cuttime = 0,
  ppd.dist = c("exp", "weibullPH", "llogis", "lnorm", "gamma", "gompertz"),
  ttp.dist = c("exp", "weibullPH", "llogis", "lnorm", "gamma", "gompertz"),
  pfs.dist = c("exp", "weibullPH", "llogis", "lnorm", "gamma", "gompertz"),
  os.dist = c("exp", "weibullPH", "llogis", "lnorm", "gamma", "gompertz"),
  pps_cf.dist = c("exp", "weibullPH", "llogis", "lnorm", "gamma", "gompertz"),
  pps_cr.dist = c("exp", "weibullPH", "llogis", "lnorm", "gamma", "gompertz"),
  expvar = NA
)
}
\arguments{
\item{simdat}{Dataset of patient level data. Must be a tibble with columns named:
\itemize{
\item ptid: patient identifier
\item pfs.durn: duration of PFS from baseline
\item pfs.flag: event flag for PFS (=1 if progression or death occurred, 0 for censoring)
\item os.durn: duration of OS from baseline
\item os.flag: event flag for OS (=1 if death occurred, 0 for censoring)
\item ttp.durn: duration of TTP from baseline (usually should be equal to pfs.durn)
\item ttp.flag: event flag for TTP (=1 if progression occurred, 0 for censoring).
}

Survival data for all other endpoints (time to progression, pre-progression death, post-progression survival) are derived from PFS and OS.}

\item{cuttime}{Cut-off time for a two-piece model, equals zero for one-piece models.}

\item{ppd.dist}{Vector of distributions (named per \code{\link[flexsurv:flexsurvreg]{flexsurv::flexsurvreg()}}) to be fitted to Pre-Progression Death (PPD).}

\item{ttp.dist}{Vector of distributions (named per \code{\link[flexsurv:flexsurvreg]{flexsurv::flexsurvreg()}}) to be fitted to Time To Progression (TTP).}

\item{pfs.dist}{Vector of distributions (named per \code{\link[flexsurv:flexsurvreg]{flexsurv::flexsurvreg()}}) to be fitted to Progression-Free Survival (PFS).}

\item{os.dist}{Vector of distributions (named per \code{\link[flexsurv:flexsurvreg]{flexsurv::flexsurvreg()}}) to be fitted to Overall Survival (OS).}

\item{pps_cf.dist}{Vector of distributions (named per \code{\link[flexsurv:flexsurvreg]{flexsurv::flexsurvreg()}}) to be fitted to Post Progression Survival, where time is from baseline (clock forward).}

\item{pps_cr.dist}{Vector of distributions (named per \code{\link[flexsurv:flexsurvreg]{flexsurv::flexsurvreg()}}) to be fitted to Post Progression Survival, where time is from progression (clock reset).}

\item{expvar}{Explanatory variable for modeling of PPS}
}
\value{
A list by endpoint, then distribution, each containing two components:
\itemize{
\item result: A list of class \emph{flexsurvreg} containing information about the fitted model.
\item error: Any error message returned on fitting the regression (NULL indicates no error).
}
}
\description{
Fits multiple parametric survival regressions, according to the distributions stipulated, to the multiple endpoints required in fitting partitioned survival analysis, clock forward and clock reset semi-markov models.
}
\examples{
bosonc <- create_dummydata("flexbosms")
fit_ends_mods_par(bosonc, expvar=bosonc$ttp.durn)
}
\seealso{
Spline modeling is handled by \code{\link[=fit_ends_mods_spl]{fit_ends_mods_spl()}}
}
