% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probgraphs.R
\name{prob_pd_psm}
\alias{prob_pd_psm}
\title{Calculate membership probability of progressed disease state in a partitioned survival model}
\usage{
prob_pd_psm(time, dpam, starting = c(1, 0, 0))
}
\arguments{
\item{time}{Time (numeric and vectorized)}

\item{dpam}{List of survival regressions for model endpoints. This must include progression-free survival (PFS) and overall survival (OS).}

\item{starting}{Vector of membership probabilities (PF, PD, death) at time zero.}
}
\value{
Numeric value
}
\description{
Calculates membership probability of having progressed disease at a particular time (vectorized), given the partitioned survival model with certain statistical distributions and parameters.
}
\examples{
\donttest{
bosonc <- create_dummydata("flexbosms")
fits <- fit_ends_mods_spl(bosonc)
# Pick out best distribution according to min AIC
params <- list(
  ppd = find_bestfit(fits$ppd, "aic")$fit,
  ttp = find_bestfit(fits$ttp, "aic")$fit,
  pfs = find_bestfit(fits$pfs, "aic")$fit,
  os = find_bestfit(fits$os, "aic")$fit,
  pps_cf = find_bestfit(fits$pps_cf, "aic")$fit,
  pps_cr = find_bestfit(fits$pps_cr, "aic")$fit
)
prob_pd_psm(0:100, params)
}
}
