% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probgraphs.R
\name{prob_pps_cf}
\alias{prob_pps_cf}
\title{Calculate probability of post progression survival under the state transition clock forward model}
\usage{
prob_pps_cf(ttptimes, ppstimes, dpam)
}
\arguments{
\item{ttptimes}{Time (numeric and vectorized) from progression - not time from baseline.}

\item{ppstimes}{Time (numeric and vectorized) of progression}

\item{dpam}{List of survival regressions for model endpoints. This must include post progression survival calculated under the clock forward state transition model.}
}
\value{
Vector of the mean probabilities of post-progression survival at each PPS time, averaged over TTP times.
}
\description{
Calculates probability of post progression survival at a given time from progression (vectorized). This probability is from the state transition clock forward model, according to the given statistical distributions and parameters.
}
\examples{
\donttest{
bosonc <- create_dummydata("flexbosms")
fits <- fit_ends_mods_spl(bosonc)
# Pick out best distribution according to min AIC
params <- list(
  ppd = find_bestfit(fits$ppd, "aic")$fit,
  ttp = find_bestfit(fits$ttp, "aic")$fit,
  pfs = find_bestfit(fits$pfs, "aic")$fit,
  os = find_bestfit(fits$os, "aic")$fit,
  pps_cf = find_bestfit(fits$pps_cf, "aic")$fit,
  pps_cr = find_bestfit(fits$pps_cr, "aic")$fit
)
prob_pps_cf(0:100, 0:100, params)
}
}
