% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_terms.R
\name{plot_terms}
\alias{plot_terms}
\title{Plot terms of the non-parametric covariates in the
  semiparametric regression models.}
\usage{
plot_terms(
  fitterms,
  data,
  conflevel = 0.95,
  listw = NULL,
  dynamic = FALSE,
  nt = NULL
)
}
\arguments{
\item{fitterms}{object returned from \code{\link{fit_terms}} function.}

\item{data}{dataframe or sf with the data.}

\item{conflevel}{numerical value for the confidence interval of the
term. Default 0.95.}

\item{listw}{used to compute spatial lags for Durbin specifications. 
Default =  `NULL`}

\item{dynamic}{Logical value to set a dynamic model.
Dynamic models include a temporal lag of the dependent
variable in the right-hand side of the equation.
Default = `FALSE`.}

\item{nt}{Number of temporal periods. It is needed
for dynamic models.}
}
\value{
list with the plots of the terms for each non-parametric 
  covariate included in the object returned from \code{\link{fit_terms}}.
}
\description{
For each non-parametric covariate the plot of the term
  includes confidence intervals and the decomposition in fixed and 
  random part when the term is reparameterized as a mixed model.
}
\examples{
 ###################### unemployment for 103 Italian provinces in period 1996-2014.
library(pspatreg)
data(unemp_it, package = "pspatreg")
lwsp_it <- spdep::mat2listw(Wsp_it)
unemp_it_short <- unemp_it[unemp_it$year == 2019, ]

########  No Spatial Trend: PSAR including a spatial 
########  lag of the dependent variable
form1 <- unrate ~ partrate + agri + cons +
                  pspl(serv,nknots=15) +
                  pspl(empgrowth,nknots=20) 
gamsar <- pspatfit(form1, data = unemp_it_short, 
                   type = "sar", listw = Wsp_it)
summary(gamsar)
########  Fit non-parametric terms (spatial trend must be name "spttrend")
list_varnopar <- c("serv", "empgrowth")
terms_nopar <- fit_terms(gamsar, list_varnopar)
#######  Plot non-parametric terms
plot_terms(terms_nopar, unemp_it_short)
 
}
\references{
\itemize{ 
  \item Wood, S.N. (2017). \emph{Generalized Additive Models. 
  An Introduction with \code{R}} (second edition). CRC Press, Boca Raton.
 }
}
\seealso{
\itemize{
  \item \code{\link{fit_terms}} compute smooth functions for non-parametric
                                continuous covariates.
  \item \code{\link{impactsnopar}} plot the effects functions 
    of non-parametric covariates.
  \item \code{\link[mgcv]{vis.gam}} plot the terms fitted by 
    \code{\link[mgcv]{gam}} function in \pkg{mgcv} package.   
}
}
\author{
\tabular{ll}{ 
  Roman Minguez  \tab \email{roman.minguez@uclm.es} \cr
  Roberto Basile \tab \email{roberto.basile@univaq.it} \cr Maria Durban \tab
  \email{mdurban@est-econ.uc3m.es} \cr Gonzalo Espana-Heredia \tab
  \email{gehllanza@gmail.com} \cr 
 }
}
