% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anova.R
\name{sphericityValueString}
\alias{sphericityValueString}
\title{sphericityValueString}
\usage{
sphericityValueString(aovObj, effect)
}
\arguments{
\item{aovObj}{The returned object from a call to ezANOVA}

\item{effect}{The effect within the ANOVA table to return}
}
\value{
character
}
\description{
Returns required Latex formatted string for sphericity epsilon
values (HF, GG) = XXX for R/knitr integration. Returns values
to 2 sig decimal places.
}
\examples{
# Example 1
# create dataframe and add data with 3(Comp: neutral vs. comp vs. incomp) levels
dat <- createDF(nVP = 20, nTrl = 1,
                design = list("Comp" = c("neutral", "comp", "incomp")))

dat <- addDataDF(dat, RT = list("Comp_neutral" = c(510, 150, 100),
                                "Comp_comp"    = c(500, 150, 100),
                                "Comp_incomp"  = c(520, 150, 100)))

# repeated measures ANOVA using ezANOVA
library(ez)
aovRT <- ezANOVA(dat, dv=.(RT), wid = .(VP), within = .(Comp),
                 return_aov = TRUE, detailed = TRUE)
aovRT <- aovTable(aovRT)

sphericityValue <- sphericityValueString(aovRT, "Comp")

}
