% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correct_r.R
\name{correct_r_dich}
\alias{correct_r_dich}
\title{Correct correlations for artifical dichotomization of one or both variables}
\usage{
correct_r_dich(r, p_x = NA, p_y = NA, n = NULL)
}
\arguments{
\item{r}{Vector of correlations attenuated by artificial dichomization.}

\item{p_x}{Vector of proportions of the distribution on either side of the split applied to X (set as NA if X is continuous).}

\item{p_y}{Vector of proportions of the distribution on either side of the split applied to Y (set as NA if Y is continuous).}

\item{n}{Optional vector of sample sizes.}
}
\value{
Vector of correlations corrected for artificial dichomization (if \code{n} is supplied, corrected error variance and adjusted sample size is also reported).
}
\description{
Correct correlations for artifical dichotomization of one or both variables
}
\details{
\deqn{r_{c}=\frac{r_{obs}}{\left[\frac{\phi\left(p_{X}\right)}{p_{X}\left(1-p_{X}\right)}\right]\left[\frac{\phi\left(p_{Y}\right)}{p_{Y}\left(1-p_{Y}\right)}\right]}}{r_c = r_obs / (ordinate(p_x) / sqrt(p_x * (1 - p_x) * ordinate(p_y) / sqrt(p_y * (1 - p_y))}
}
\examples{
correct_r_dich(r = 0.32, p_x = .5, p_y = .5, n = 100)
}
\references{
Schmidt, F. L., & Hunter, J. E. (2015).
\emph{Methods of meta-analysis: Correcting error and bias in research findings} (3rd ed.).
Thousand Oaks, CA: SAGE. \url{https://doi.org/10/b6mg}. pp. 43–44.
}
