% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reshape.R
\name{reshape_wide2long}
\alias{reshape_wide2long}
\title{Reshape database from wide format to long format}
\usage{
reshape_wide2long(
  data,
  common_vars = NULL,
  es_design = NULL,
  n_design = NULL,
  other_design = NULL,
  es_name = "rxyi",
  missing_col_action = c("warn", "ignore", "stop")
)
}
\arguments{
\item{data}{Database of data for use in a meta-analysis in "wide" format.}

\item{common_vars}{String vector of column names relevant to all variables in data.}

\item{es_design}{p x p matrix containing the names of columns of intercorrelations among variables in the lower triangle of the matrix.}

\item{n_design}{Scalar sample-size column name or a p x p matrix containing the names of columns of sample sizes the lower triangle of the matrix.}

\item{other_design}{A matrix with variable names on the rows and names of long-format variables to create on the columns. Elements of this
matrix must be column names of \code{data}.}

\item{es_name}{Name of the effect size represented in \code{data}.}

\item{missing_col_action}{Character scalar indicating how missing columns should be handled. Options are: "warn", "ignore", and "stop"}
}
\value{
A long-format database
}
\description{
This function automates the process of converting a wide-format database (i.e., a database in which intercorrelations between construct pairs define the columns, such that there are multiple columns of correlations) to a long-format database (i.e., a database with just one column of correlations).
The meta-analysis functions in \pkg{psychmeta} work best with long-format databases, so this function can be a helpful addition to one's workflow when data are organized in a wide format.
}
\examples{
n_params = c(mean = 150, sd = 20)
rho_params <- list(c(.1, .3, .5),
                   c(mean = .3, sd = .05),
                   rbind(value = c(.1, .3, .5), weight = c(1, 2, 1)))
rel_params = list(c(.7, .8, .9),
                  c(mean = .8, sd = .05),
                  rbind(value = c(.7, .8, .9), weight = c(1, 2, 1)))
sr_params = c(list(1, 1, c(.5, .7)))
sr_composite_params = list(1, c(.5, .6, .7))
wt_params = list(list(c(1, 2, 3),
                      c(mean = 2, sd = .25),
                      rbind(value = c(1, 2, 3), weight = c(1, 2, 1))),
                 list(c(1, 2, 3),
                      c(mean = 2, sd = .25),
                      rbind(value = c(1, 2, 3), weight = c(1, 2, 1))))

## Simulate with wide format
data <- simulate_r_database(k = 10, n_params = n_params, rho_params = rho_params,
                          rel_params = rel_params, sr_params = sr_params,
                          sr_composite_params = sr_composite_params, wt_params = wt_params,
                          var_names = c("X", "Y", "Z"), format = "wide")$statistics

## Define values to abstract from the data object
common_vars <- "sample_id"
es_design <- matrix(NA, 3, 3)
var_names <- c("X", "Y", "Z")
es_design[lower.tri(es_design)] <- c("rxyi_X_Y", "rxyi_X_Z", "rxyi_Y_Z")
rownames(es_design) <- colnames(es_design) <- var_names
n_design <- "ni"
other_design <- cbind(rxxi = paste0("parallel_rxxi_", var_names),
                      ux_local = paste0("ux_local_", var_names),
                      ux_external = paste0("ux_external_", var_names))
rownames(other_design) <- var_names

## Reshape the data to "long" format
reshape_wide2long(data = data, common_vars = common_vars, es_design = es_design,
                           n_design = n_design, other_design = other_design)
}
