% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_ads.R
\name{summarize_ads}
\alias{summarize_ads}
\title{Summarize artifact information from meta-analyses into table format}
\usage{
summarize_ads(ma_obj)
}
\arguments{
\item{ma_obj}{A meta-analysis object of correlations or d values with psychometric information.}
}
\value{
A table of artifact information.
}
\description{
Summarize artifact information from meta-analyses into table format
}
\examples{
\dontrun{
## Artifact distributions from "ma_r" with individual corrections
ma_obj_ic_pairwise <- ma_r(ma_method = "ic", rxyi = "rxyi", n = "n",
                           rxx = "rxxi", ryy = "ryyi",
                           pairwise_ads = TRUE,
                           correct_rr_x = FALSE, correct_rr_y = FALSE,
                           construct_x = "x_name", construct_y = "y_name",
                           sample_id = "sample_id", moderators = "moderator",
                           data = data_r_meas_multi)
summarize_ads(ma_obj = ma_obj_ic_pairwise)

## Artifact distributions from "ma_r" with artifact-distribution corrections (pairwise ADs)
ma_obj_ad_pairwise <- ma_r(ma_method = "ad", rxyi = "rxyi", n = "n",
                           rxx = "rxxi", ryy = "ryyi",
                           pairwise_ads = TRUE,
                           correct_rr_x = FALSE, correct_rr_y = FALSE,
                           construct_x = "x_name", construct_y = "y_name",
                           sample_id = "sample_id", moderators = "moderator",
                           data = data_r_meas_multi)
summarize_ads(ma_obj = ma_obj_ad_pairwise)

## Artifact distributions from "ma_r" with artifact-distribution corrections (overall ADs)
ma_obj_ad_nonpairwise <- ma_r(ma_method = "ad", rxyi = "rxyi", n = "n",
                              rxx = "rxxi", ryy = "ryyi",
                              pairwise_ads = FALSE,
                              correct_rr_x = FALSE, correct_rr_y = FALSE,
                              construct_x = "x_name", construct_y = "y_name",
                              sample_id = "sample_id", moderators = "moderator",
                              data = data_r_meas_multi)
summarize_ads(ma_obj = ma_obj_ad_nonpairwise)
}
}
\keyword{internal}
